/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.customproviders;

import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.http.Headers;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.util.function.Supplier;
import org.jboss.resteasy.reactive.server.ServerResponseFilter;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class NoTargetTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{HelloResource.class, ThrowingPreMatchFilter.class, DummyExceptionMapper.class});
        }
    });

    @Test
    public void test() {
        Headers headers = ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/hello", (Object[])new Object[0]).then()).statusCode(200)).extract().headers();
        Assertions.assertEquals((Object)"mapper", (Object)headers.get("source").getValue());
        Assertions.assertEquals((Object)"NullValues", (Object)headers.get("resourceInfoClass").getValue());
    }

    public static class DummyException
    extends RuntimeException {
        public DummyException() {
            super("dummy");
            this.setStackTrace(new StackTraceElement[0]);
        }
    }

    @Provider
    public static class DummyExceptionMapper
    implements ExceptionMapper<DummyException> {
        public Response toResponse(DummyException exception) {
            return Response.ok().header("source", (Object)"mapper").build();
        }
    }

    @PreMatching
    @Provider
    public static class ThrowingPreMatchFilter
    implements ContainerRequestFilter {
        public void filter(ContainerRequestContext requestContext) throws IOException {
            throw new DummyException();
        }
    }

    public static class CustomResponseFilter {
        @ServerResponseFilter
        public void filter(ContainerResponseContext responseContext, ResourceInfo resourceInfo) {
            responseContext.getHeaders().add((Object)"resourceInfoClass", (Object)resourceInfo.getClass().getSimpleName());
        }
    }

    @Path(value="hello")
    public static class HelloResource {
        @GET
        public String hello() {
            return "hello";
        }
    }
}

