/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.customproviders;

import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.HttpHeaders;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.resteasy.reactive.RestForm;
import org.jboss.resteasy.reactive.RestQuery;
import org.jboss.resteasy.reactive.server.ServerRequestFilter;
import org.jboss.resteasy.reactive.server.WithFormRead;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveContainerRequestContext;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class ReadBodyRequestFilterTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{HelloResource.class});
        }
    });

    @Test
    public void testMethodWithBody() {
        ((ValidatableResponse)((Response)RestAssured.with().formParam("name", new Object[]{"Quarkus"}).post("/hello", new Object[0])).then()).body(Matchers.equalTo((Object)"hello Quarkus!!!!!!!"), new Matcher[0]);
    }

    @Test
    public void testMethodWithUndeclaredBody() {
        ((ValidatableResponse)((Response)RestAssured.with().formParam("name", new Object[]{"Quarkus"}).post("/hello/empty", new Object[0])).then()).body(Matchers.equalTo((Object)"hello !!!!!!!"), new Matcher[0]);
    }

    @Test
    public void testMethodWithStringBody() {
        ((ValidatableResponse)((Response)RestAssured.with().formParam("name", new Object[]{"Quarkus"}).post("/hello/string", new Object[0])).then()).body(Matchers.equalTo((Object)"hello name=Quarkus!!!!!!!"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.with().body("Quarkus").post("/hello/string", new Object[0])).then()).body(Matchers.equalTo((Object)"hello Quarkus?"), new Matcher[0]);
    }

    @Test
    public void testMethodWithoutBody() {
        ((ValidatableResponse)((Response)RestAssured.with().queryParam("name", new Object[]{"Quarkus"}).get("/hello", new Object[0])).then()).body(Matchers.equalTo((Object)"hello Quarkus!"), new Matcher[0]);
    }

    public static class Filters {
        @WithFormRead
        @ServerRequestFilter(readBody=true)
        public void addSuffix(ResteasyReactiveContainerRequestContext containerRequestContext) {
            ResteasyReactiveRequestContext rrContext = (ResteasyReactiveRequestContext)containerRequestContext.getServerRequestContext();
            if (containerRequestContext.getMethod().equals("POST")) {
                String nameFormParam = (String)rrContext.getFormParameter("name", true, false);
                if (nameFormParam != null) {
                    containerRequestContext.getHeaders().putSingle((Object)"suffix", (Object)"!".repeat(nameFormParam.length()));
                } else {
                    containerRequestContext.getHeaders().putSingle((Object)"suffix", (Object)"?");
                }
            } else {
                containerRequestContext.getHeaders().putSingle((Object)"suffix", (Object)"!");
            }
        }
    }

    @Path(value="hello")
    public static class HelloResource {
        @POST
        public String helloPost(@RestForm String name, HttpHeaders headers) {
            return "hello " + name + headers.getHeaderString("suffix");
        }

        @Path(value="empty")
        @POST
        public String helloEmptyPost(HttpHeaders headers) {
            return "hello " + headers.getHeaderString("suffix");
        }

        @Path(value="string")
        @POST
        public String helloStringPost(String body, HttpHeaders headers) {
            return "hello " + body + headers.getHeaderString("suffix");
        }

        @GET
        public String helloGet(@RestQuery String name, HttpHeaders headers) {
            return "hello " + name + headers.getHeaderString("suffix");
        }
    }
}

