/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.customproviders;

import io.quarkus.resteasy.reactive.server.test.customproviders.UniException;
import io.quarkus.resteasy.reactive.server.test.customproviders.UniExceptionMapper;
import io.quarkus.resteasy.reactive.server.test.customproviders.UniFiltersResource;
import io.quarkus.resteasy.reactive.server.test.customproviders.UniResponseFilter;
import io.quarkus.resteasy.reactive.server.test.customproviders.UniResponseRequestFilter;
import io.quarkus.resteasy.reactive.server.test.customproviders.UniVoidRequestFilter;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.http.Headers;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class UniFiltersTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{UniVoidRequestFilter.class, UniResponseRequestFilter.class, UniResponseFilter.class, UniException.class, UniExceptionMapper.class, UniFiltersResource.class});
        }
    });

    @Test
    public void testUniVoid() {
        Headers headers = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("some-uni-input", (Object)"bar", new Object[0]).get("/uni/req", new Object[0])).then()).statusCode(200)).body(Matchers.containsString((String)"/uni/req-bar"), new Matcher[0])).extract().headers();
        Assertions.assertThat((List)headers.getValues("java-method")).containsOnly((Object[])new String[]{"filters"});
    }

    @Test
    public void testUniVoidThrowingException() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("some-uni-exception-input", (Object)"whatever", new Object[0]).get("/uni/req", new Object[0])).then()).statusCode(202)).body(Matchers.containsString((String)"whatever"), new Matcher[0]);
    }

    @Test
    public void testUniResponseReturningNull() {
        Headers headers = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("some-other-uni-input", (Object)"bar", new Object[0]).get("/uni/req", new Object[0])).then()).statusCode(200)).body(Matchers.containsString((String)"/uni/req-bar"), new Matcher[0])).extract().headers();
        Assertions.assertThat((List)headers.getValues("java-method")).containsOnly((Object[])new String[]{"filters"});
    }

    @Test
    public void testUniVoidReturningResponse() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("some-other-uni-exception-input", (Object)"whatever", new Object[0]).get("/uni/req", new Object[0])).then()).statusCode(500)).body(Matchers.containsString((String)"whatever"), new Matcher[0]);
    }
}

