/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.customproviders;

import io.quarkus.runtime.BlockingOperationControl;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.http.Headers;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.smallrye.common.annotation.Blocking;
import io.smallrye.common.annotation.NonBlocking;
import io.smallrye.mutiny.Uni;
import jakarta.annotation.Priority;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.util.function.Supplier;
import org.jboss.resteasy.reactive.server.ServerRequestFilter;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class ValidNonBlockingFiltersTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{StandardBlockingRequestFilter.class, AnotherStandardBlockingRequestFilter.class, StandardNonBlockingRequestFilter.class, DummyResource.class});
        }
    });

    @Test
    public void testBlockingEndpoint() {
        Headers headers = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/dummy/blocking", new Object[0])).then()).statusCode(200)).extract().headers();
        Assertions.assertEquals((Object)"1-custom-non-blocking/2-another-custom-non-blocking/3-standard-non-blocking/4-standard-blocking/5-another-standard-blocking/6-custom-blocking", (Object)headers.get("filter-request").getValue());
        Assertions.assertEquals((Object)"false/false/false/true/true/true", (Object)headers.get("thread").getValue());
    }

    @Test
    public void testNonBlockingEndpoint() {
        Headers headers = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/dummy/nonblocking", new Object[0])).then()).statusCode(200)).extract().headers();
        Assertions.assertEquals((Object)"1-custom-non-blocking/2-another-custom-non-blocking/3-standard-non-blocking/4-standard-blocking/5-another-standard-blocking/6-custom-blocking", (Object)headers.get("filter-request").getValue());
        Assertions.assertEquals((Object)"false/false/false/false/false/false", (Object)headers.get("thread").getValue());
    }

    public static class CustomFilters {
        @ServerRequestFilter(nonBlocking=true)
        public void firstNonBlocking(ContainerRequestContext requestContext) {
            MultivaluedMap headers = requestContext.getHeaders();
            String previousFilterHeaderValue = (String)headers.getFirst((Object)"filter-request");
            headers.putSingle((Object)"filter-request", (Object)"1-custom-non-blocking");
            headers.putSingle((Object)"thread", (Object)("" + BlockingOperationControl.isBlockingAllowed()));
        }

        @ServerRequestFilter(nonBlocking=true, priority=5020)
        public void anotherNonBlocking(ContainerRequestContext requestContext) {
            MultivaluedMap headers = requestContext.getHeaders();
            String previousFilterHeaderValue = (String)headers.getFirst((Object)"filter-request");
            headers.putSingle((Object)"filter-request", (Object)(previousFilterHeaderValue + "/2-another-custom-non-blocking"));
            String previousThreadHeaderValue = (String)headers.getFirst((Object)"thread");
            headers.putSingle((Object)"thread", (Object)(previousThreadHeaderValue + "/" + BlockingOperationControl.isBlockingAllowed()));
        }

        @ServerRequestFilter(priority=5300)
        public void blocking(ContainerRequestContext requestContext) {
            MultivaluedMap headers = requestContext.getHeaders();
            String previousFilterHeaderValue = (String)headers.getFirst((Object)"filter-request");
            headers.putSingle((Object)"filter-request", (Object)(previousFilterHeaderValue + "/6-custom-blocking"));
            String previousThreadHeaderValue = (String)headers.getFirst((Object)"thread");
            headers.putSingle((Object)"thread", (Object)(previousThreadHeaderValue + "/" + BlockingOperationControl.isBlockingAllowed()));
        }
    }

    @Provider
    @Priority(value=5050)
    @NonBlocking
    public static class StandardNonBlockingRequestFilter
    implements ContainerRequestFilter {
        public void filter(ContainerRequestContext requestContext) throws IOException {
            MultivaluedMap headers = requestContext.getHeaders();
            String previousFilterHeaderValue = (String)headers.getFirst((Object)"filter-request");
            headers.putSingle((Object)"filter-request", (Object)(previousFilterHeaderValue + "/3-standard-non-blocking"));
            String previousThreadHeaderValue = (String)headers.getFirst((Object)"thread");
            headers.putSingle((Object)"thread", (Object)(previousThreadHeaderValue + "/" + BlockingOperationControl.isBlockingAllowed()));
        }
    }

    @Provider
    @Priority(value=5200)
    public static class AnotherStandardBlockingRequestFilter
    implements ContainerRequestFilter {
        public void filter(ContainerRequestContext requestContext) throws IOException {
            MultivaluedMap headers = requestContext.getHeaders();
            String previousFilterHeaderValue = (String)headers.getFirst((Object)"filter-request");
            headers.putSingle((Object)"filter-request", (Object)(previousFilterHeaderValue + "/5-another-standard-blocking"));
            String previousThreadHeaderValue = (String)headers.getFirst((Object)"thread");
            headers.putSingle((Object)"thread", (Object)(previousThreadHeaderValue + "/" + BlockingOperationControl.isBlockingAllowed()));
        }
    }

    @Provider
    @Priority(value=5100)
    public static class StandardBlockingRequestFilter
    implements ContainerRequestFilter {
        public void filter(ContainerRequestContext requestContext) throws IOException {
            MultivaluedMap headers = requestContext.getHeaders();
            String previousFilterHeaderValue = (String)headers.getFirst((Object)"filter-request");
            headers.putSingle((Object)"filter-request", (Object)(previousFilterHeaderValue + "/4-standard-blocking"));
            String previousThreadHeaderValue = (String)headers.getFirst((Object)"thread");
            headers.putSingle((Object)"thread", (Object)(previousThreadHeaderValue + "/" + BlockingOperationControl.isBlockingAllowed()));
        }
    }

    @Path(value="dummy")
    public static class DummyResource {
        @Blocking
        @Path(value="blocking")
        @GET
        public jakarta.ws.rs.core.Response blocking(@Context HttpHeaders headers) {
            return this.getResponse(headers);
        }

        @Path(value="nonblocking")
        @GET
        public Uni<jakarta.ws.rs.core.Response> nonblocking(@Context HttpHeaders headers) {
            return Uni.createFrom().item((Object)this.getResponse(headers));
        }

        private jakarta.ws.rs.core.Response getResponse(HttpHeaders headers) {
            return jakarta.ws.rs.core.Response.ok().header("filter-request", (Object)headers.getHeaderString("filter-request")).header("thread", (Object)headers.getHeaderString("thread")).build();
        }
    }
}

