/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.devmode;

import io.quarkus.resteasy.reactive.server.deployment.ResteasyReactiveDevModeProcessor;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConsolePathCompleterTestCase {
    @Test
    public void testPathCompletion() {
        ResteasyReactiveDevModeProcessor.CompletionResult result = ResteasyReactiveDevModeProcessor.PathCompleter.complete(Set.of("/fruit", "/fruit/{foo}", "/fruit/{foo}/bar"), (String)"/fruit/1/");
        Assertions.assertEquals(Set.of("/fruit/1/bar"), (Object)result.getResults());
        Assertions.assertTrue((boolean)result.isAppendSpace());
        result = ResteasyReactiveDevModeProcessor.PathCompleter.complete(Set.of("/fruit"), (String)"/");
        Assertions.assertTrue((boolean)result.isAppendSpace());
        Assertions.assertEquals(Set.of("/fruit"), (Object)result.getResults());
        result = ResteasyReactiveDevModeProcessor.PathCompleter.complete(Set.of("/fruit", "/fruit/{foo}"), (String)"/");
        Assertions.assertFalse((boolean)result.isAppendSpace());
        Assertions.assertEquals(Set.of("/fruit", "/fruit/"), (Object)result.getResults());
        result = ResteasyReactiveDevModeProcessor.PathCompleter.complete(Set.of("/fruit", "/fruit/{foo}"), (String)"/fruit");
        Assertions.assertFalse((boolean)result.isAppendSpace());
        Assertions.assertEquals(Set.of("/fruit/{foo}"), (Object)result.getResults());
        result = ResteasyReactiveDevModeProcessor.PathCompleter.complete(Set.of("/fruit", "/fruit/{foo}"), (String)"/fruit/1");
        Assertions.assertEquals(Set.of("/fruit/{foo}"), (Object)result.getResults());
        Assertions.assertFalse((boolean)result.isAppendSpace());
    }
}

