/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.headers;

import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.http.Headers;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jboss.resteasy.reactive.ResponseHeader;
import org.jboss.resteasy.reactive.ResponseStatus;
import org.jboss.resteasy.reactive.RestMulti;
import org.jboss.resteasy.reactive.RestQuery;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class ResponseHeaderTest {
    @RegisterExtension
    static QuarkusUnitTest TEST = new QuarkusUnitTest().withApplicationRoot(jar -> jar.addClasses(new Class[]{TestResource.class}));

    @Test
    public void testReturnUni() {
        Map<String, String> expectedHeaders = Map.of("Access-Control-Allow-Origin", "*", "Keep-Alive", "timeout=5, max=997");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/test/uni", new Object[0])).then()).statusCode(200)).headers(expectedHeaders);
    }

    @Test
    public void testReturnUniAndContainsResponseStatus() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/test/uni2", new Object[0])).then()).statusCode(201)).headers(Collections.singletonMap("foo", "bar"));
    }

    @Test
    public void testReturnMulti() {
        Map<String, String> expectedHeaders = Map.of("Access-Control-Allow-Origin", "*", "Keep-Alive", "timeout=5, max=997");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/test/multi", new Object[0])).then()).statusCode(200)).headers(expectedHeaders);
    }

    @Test
    public void testReturnCompletionStage() {
        Map<String, String> expectedHeaders = Map.of("Access-Control-Allow-Origin", "*", "Keep-Alive", "timeout=5, max=997");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/test/completion", new Object[0])).then()).statusCode(200)).headers(expectedHeaders);
    }

    @Test
    public void testReturnString() {
        Map<String, String> expectedHeaders = Map.of("Access-Control-Allow-Origin", "*", "Keep-Alive", "timeout=5, max=997");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/test/plain", new Object[0])).then()).statusCode(200)).headers(expectedHeaders);
    }

    @Test
    public void testUniThrowsException() {
        Headers headers = ((ValidatableResponse)((Response)RestAssured.given().get("/test/exception_uni", new Object[0])).then()).extract().headers();
        Assertions.assertFalse((boolean)headers.hasHeaderWithName("Access-Control-Allow-Origin"));
    }

    @Test
    public void testMultiThrowsException() {
        Headers headers = ((ValidatableResponse)((Response)RestAssured.given().get("/test/exception_multi", new Object[0])).then()).extract().headers();
        Assertions.assertFalse((boolean)headers.hasHeaderWithName("Access-Control-Allow-Origin"));
    }

    @Test
    public void testCompletionStageThrowsException() {
        Headers headers = ((ValidatableResponse)((Response)RestAssured.given().get("/test/exception_completion", new Object[0])).then()).extract().headers();
        Assertions.assertFalse((boolean)headers.hasHeaderWithName("Access-Control-Allow-Origin"));
    }

    @Test
    public void testStringThrowsException() {
        Headers headers = ((ValidatableResponse)((Response)RestAssured.given().get("/test/exception_plain", new Object[0])).then()).extract().headers();
        Assertions.assertFalse((boolean)headers.hasHeaderWithName("Access-Control-Allow-Origin"));
    }

    @Test
    public void testReturnRestMulti() {
        Map<String, String> expectedHeaders = Map.of("Access-Control-Allow-Origin", "foo", "Keep-Alive", "bar");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/test/rest-multi", new Object[0])).then()).statusCode(200)).headers(expectedHeaders);
    }

    @Test
    public void testReturnRestMulti2() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/test/rest-multi2", new Object[0])).then()).statusCode(200)).headers(Map.of("Access-Control-Allow-Origin", "foo", "Keep-Alive", "bar"));
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/test/rest-multi2?keepAlive=dummy", new Object[0])).then()).statusCode(200)).headers(Map.of("Access-Control-Allow-Origin", "foo", "Keep-Alive", "dummy"));
    }

    @Test
    public void testReturnRestMulti3() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/test/rest-multi3", new Object[0])).then()).statusCode(200)).headers(Map.of("header1", "foo", "header2", "bar"));
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/test/rest-multi3?h1=h1&h2=h2", new Object[0])).then()).statusCode(200)).headers(Map.of("header1", "h1", "header2", "h2"));
    }

    @Test
    public void testReturnRestMulti4() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/test/rest-multi2", new Object[0])).then()).statusCode(200)).contentType(ContentType.TEXT)).headers(Map.of("Access-Control-Allow-Origin", "foo", "Keep-Alive", "bar"));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/test/rest-multi2?keepAlive=dummy", new Object[0])).then()).statusCode(200)).contentType(ContentType.TEXT)).headers(Map.of("Access-Control-Allow-Origin", "foo", "Keep-Alive", "dummy"));
    }

    @Test
    public void testReturnRestMulti5() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/test/rest-multi3", new Object[0])).then()).statusCode(200)).headers(Map.of("header1", "foo", "header2", "bar"));
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/test/rest-multi3?h1=h1&h2=h2", new Object[0])).then()).statusCode(200)).headers(Map.of("header1", "h1", "header2", "h2"));
    }

    @Path(value="/test")
    public static class TestResource {
        private static final StackTraceElement[] EMPTY_STACK_TRACE = new StackTraceElement[0];

        @ResponseHeader.List(value={@ResponseHeader(name="Access-Control-Allow-Origin", value={"*"}), @ResponseHeader(name="Keep-Alive", value={"timeout=5, max=997"})})
        @GET
        @Path(value="/uni")
        public Uni<String> getTestUni() {
            return Uni.createFrom().item((Object)"test");
        }

        @ResponseHeader(name="foo", value={"bar"})
        @ResponseStatus(value=201)
        @GET
        @Path(value="/uni2")
        public Uni<String> getTestUni2() {
            return Uni.createFrom().item((Object)"test");
        }

        @ResponseHeader.List(value={@ResponseHeader(name="Access-Control-Allow-Origin", value={"*"}), @ResponseHeader(name="Keep-Alive", value={"timeout=5, max=997"})})
        @GET
        @Path(value="/multi")
        public Multi<String> getTestMulti() {
            return Multi.createFrom().item((Object)"test");
        }

        @ResponseHeader.List(value={@ResponseHeader(name="Access-Control-Allow-Origin", value={"*"}), @ResponseHeader(name="Keep-Alive", value={"timeout=5, max=997"})})
        @GET
        @Path(value="/completion")
        public CompletionStage<String> getTestCompletion() {
            return CompletableFuture.supplyAsync(() -> "test");
        }

        @ResponseHeader.List(value={@ResponseHeader(name="Access-Control-Allow-Origin", value={"*"}), @ResponseHeader(name="Keep-Alive", value={"timeout=5, max=997"})})
        @GET
        @Path(value="/plain")
        public String getTestPlain() {
            return "test";
        }

        @ResponseHeader(name="Access-Control-Allow-Origin", value={"*"})
        @GET
        @Path(value="/exception_uni")
        public Uni<String> throwExceptionUni() {
            return Uni.createFrom().failure((Throwable)this.createException());
        }

        @ResponseHeader(name="Access-Control-Allow-Origin", value={"*"})
        @GET
        @Path(value="/exception_multi")
        public Multi<String> throwExceptionMulti() {
            return Multi.createFrom().failure((Throwable)this.createException());
        }

        @ResponseHeader(name="Access-Control-Allow-Origin", value={"*"})
        @Path(value="/exception_completion")
        public CompletionStage<String> throwExceptionCompletion() {
            return CompletableFuture.failedFuture(this.createException());
        }

        @ResponseHeader(name="Access-Control-Allow-Origin", value={"*"})
        @GET
        @Path(value="/exception_plain")
        public String throwExceptionPlain() {
            throw this.createException();
        }

        @ResponseHeader.List(value={@ResponseHeader(name="Access-Control-Allow-Origin", value={"*"}), @ResponseHeader(name="Keep-Alive", value={"timeout=5, max=997"})})
        @GET
        @Path(value="/rest-multi")
        public RestMulti<String> getTestRestMulti() {
            return RestMulti.fromMultiData((Multi)Multi.createFrom().item((Object)"test")).header("Access-Control-Allow-Origin", "foo").header("Keep-Alive", "bar").build();
        }

        @GET
        @Path(value="/rest-multi2")
        public RestMulti<String> getTestRestMulti2(@DefaultValue(value="bar") @RestQuery String keepAlive) {
            return RestMulti.fromMultiData((Multi)Multi.createFrom().item((Object)"test")).header("Access-Control-Allow-Origin", "foo").header("Keep-Alive", keepAlive).build();
        }

        @GET
        @Path(value="/rest-multi3")
        @Produces(value={"application/octet-stream"})
        public RestMulti<byte[]> getTestRestMulti3(@DefaultValue(value="foo") @RestQuery(value="h1") String header1, @DefaultValue(value="bar") @RestQuery(value="h2") String header2) {
            return RestMulti.fromUniResponse(this.getWrapper(header1, header2), Wrapper::getData, Wrapper::getHeaders);
        }

        @GET
        @Path(value="/rest-multi4")
        public RestMulti<byte[]> getTestRestMulti4(@DefaultValue(value="bar") @RestQuery String keepAlive) {
            return RestMulti.fromMultiData((Multi)Multi.createFrom().item((Object)"test".getBytes(StandardCharsets.UTF_8))).header("Access-Control-Allow-Origin", "foo").header("Keep-Alive", keepAlive).header("Content-Type", "text/plain").build();
        }

        @GET
        @Path(value="/rest-multi5")
        public RestMulti<byte[]> getTestRestMulti5(@DefaultValue(value="foo") @RestQuery(value="h1") String header1, @DefaultValue(value="bar") @RestQuery(value="h2") String header2) {
            return RestMulti.fromUniResponse(this.getWrapper(header1, header2), Wrapper::getData, Wrapper::getHeaders);
        }

        private IllegalArgumentException createException() {
            IllegalArgumentException result = new IllegalArgumentException();
            result.setStackTrace(EMPTY_STACK_TRACE);
            return result;
        }

        private Uni<Wrapper> getWrapper(String header1, String header2) {
            return Uni.createFrom().item(() -> new Wrapper((Multi<byte[]>)Multi.createFrom().item((Object)"test".getBytes(StandardCharsets.UTF_8)), header1, header2));
        }

        private static final class Wrapper {
            public final Multi<byte[]> data;
            public final Map<String, List<String>> headers;

            public Wrapper(Multi<byte[]> data, String header1, String header2) {
                this.data = data;
                this.headers = Map.of("header1", List.of(header1), "header2", List.of(header2));
            }

            public Multi<byte[]> getData() {
                return this.data;
            }

            public Map<String, List<String>> getHeaders() {
                return this.headers;
            }
        }
    }
}

