/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.headers;

import io.quarkus.test.QuarkusUnitTest;
import io.quarkus.vertx.web.RouteFilter;
import io.restassured.RestAssured;
import io.restassured.http.Headers;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.vertx.ext.web.RoutingContext;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class VertxHeadersTest {
    @RegisterExtension
    static QuarkusUnitTest TEST = new QuarkusUnitTest().withApplicationRoot(jar -> jar.addClasses(new Class[]{VertxFilter.class, JaxRsFilter.class, TestResource.class}));

    @Test
    void testVaryHeaderValues() {
        Headers headers = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/test", new Object[0])).then()).statusCode(200)).extract().headers();
        Assertions.assertThat((List)headers.getValues("Vary")).containsExactlyInAnyOrder((Object[])new String[]{"Origin", "Prefer"});
    }

    public static class VertxFilter {
        @RouteFilter
        void addVary(RoutingContext rc) {
            rc.response().headers().add("Vary", "Origin");
            rc.next();
        }
    }

    @Provider
    public static class JaxRsFilter
    implements ContainerResponseFilter {
        public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
            responseContext.getHeaders().add((Object)"Vary", (Object)"Prefer");
        }
    }

    @Path(value="test")
    public static class TestResource {
        @GET
        public String test() {
            return "test";
        }
    }
}

