/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.mediatype;

import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyWriter;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class NoAcceptMultipleProducesTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{DummyResource.class, DummyJsonWriter.class});
        }
    });

    @Test
    public void test() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/dummy", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body(CoreMatchers.is((Object)"{\"foo\": \"bar\"}"), new Matcher[0]);
    }

    @Provider
    @Produces(value={"application/json"})
    public static class DummyJsonWriter
    extends ServerMessageBodyWriter.AllWriteableMessageBodyWriter {
        public void writeResponse(Object o, Type genericType, ServerRequestContext context) throws WebApplicationException, IOException {
            this.doDummyWrite(context.getOrCreateOutputStream());
        }

        public void writeTo(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
            this.doDummyWrite(entityStream);
        }

        private void doDummyWrite(OutputStream outputStream) throws IOException {
            outputStream.write("{\"foo\": \"bar\"}".getBytes(StandardCharsets.UTF_8));
        }
    }

    @Path(value="dummy")
    public static class DummyResource {
        @Produces(value={"text/plain; qs=0", "application/json; qs=1"})
        @GET
        public Map<String, String> dummy() {
            return Collections.emptyMap();
        }
    }
}

