/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.multipart;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;

abstract class AbstractMultipartTest {
    AbstractMultipartTest() {
    }

    protected boolean isDirectoryEmpty(Path uploadDir) {
        File[] files = uploadDir.toFile().listFiles();
        if (files == null) {
            return true;
        }
        return files.length == 0;
    }

    protected void clearDirectory(Path uploadDir) {
        File[] files = uploadDir.toFile().listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) continue;
            file.delete();
        }
    }

    protected void awaitUploadDirectoryToEmpty(final Path uploadDir) {
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).pollInterval(Duration.ofSeconds(1L)).until((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return AbstractMultipartTest.this.isDirectoryEmpty(uploadDir);
            }
        });
    }

    protected String fileSizeAsStr(File file) throws IOException {
        return "" + Files.readAllBytes(file.toPath()).length;
    }
}

