/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.multipart;

import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.function.Supplier;
import org.jboss.resteasy.reactive.PartType;
import org.jboss.resteasy.reactive.RestForm;
import org.jboss.resteasy.reactive.common.providers.serialisers.PrimitiveBodyHandler;
import org.jboss.resteasy.reactive.server.multipart.MultipartPartReadingException;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveResourceInfo;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyReader;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class MalformedMultipartInputTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{MyEnumMessageBodyReader.class, TestMapper.class, TestEndpoint.class, Input.class, MyEnum.class});
        }
    });

    @Test
    public void properInput() {
        ((ValidatableResponse)((Response)RestAssured.given().multiPart("format", "FOO", "text/myenum").accept("text/plain").when().post("/test", new Object[0])).then()).statusCode(200);
    }

    @Test
    public void malformedInput() {
        ((ValidatableResponse)((Response)RestAssured.given().multiPart("format", "FOO2", "text/myenum").accept("text/plain").when().post("/test", new Object[0])).then()).statusCode(999);
    }

    @Provider
    @Consumes(value={"text/myenum"})
    public static class MyEnumMessageBodyReader
    extends PrimitiveBodyHandler
    implements ServerMessageBodyReader<MyEnum> {
        public boolean isReadable(Class<?> type, Type genericType, ResteasyReactiveResourceInfo lazyMethod, MediaType mediaType) {
            return type.equals(MyEnum.class);
        }

        public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return type.equals(MyEnum.class);
        }

        public MyEnum readFrom(Class<MyEnum> type, Type genericType, MediaType mediaType, ServerRequestContext context) throws WebApplicationException, IOException {
            try {
                return MyEnum.valueOf(this.readFrom(context.getInputStream(), false));
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e);
            }
        }

        public MyEnum readFrom(Class<MyEnum> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
            try {
                return MyEnum.valueOf(this.readFrom(entityStream, false));
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e);
            }
        }
    }

    @Provider
    public static class TestMapper
    implements ExceptionMapper<MultipartPartReadingException> {
        public jakarta.ws.rs.core.Response toResponse(MultipartPartReadingException e) {
            return jakarta.ws.rs.core.Response.status((int)999).build();
        }
    }

    public static enum MyEnum {
        FOO,
        BAR;

    }

    public static class Input {
        @RestForm
        @PartType(value="text/myenum")
        public MyEnum format;
    }

    @Path(value="test")
    public static class TestEndpoint {
        @Produces(value={"text/plain"})
        @Consumes(value={"multipart/form-data"})
        @POST
        public MyEnum test(@BeanParam Input formData) {
            return formData.format;
        }
    }
}

