/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.multipart;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.jboss.resteasy.reactive.server.multipart.FormValue;
import org.jboss.resteasy.reactive.server.multipart.MultipartFormDataInput;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class MultipartDataInputTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{Resource.class, Item.class, Result.class});
        }
    });
    private final File HTML_FILE = new File("./src/test/resources/test.html");
    private final File XML_FILE = new File("./src/test/resources/test.xml");

    @Test
    public void empty() {
        Result result = (Result)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType("multipart/form-data").accept("application/json").when().post("/test/0", new Object[0])).then()).statusCode(200)).extract().body().as(Result.class);
        Assertions.assertThat((Object)result).satisfies(new ThrowingConsumer[]{r -> {
            Assertions.assertThat((int)r.count).isEqualTo(0);
            Assertions.assertThat(r.items).isEmpty();
        }});
    }

    @Test
    public void multipleParts() {
        String status = "WORKING";
        Result result = (Result)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().multiPart("status", status).multiPart("htmlFile", this.HTML_FILE, "text/html").multiPart("xmlFile", this.XML_FILE, "text/xml").accept("application/json").when().post("/test/3", new Object[0])).then()).statusCode(200)).extract().body().as(Result.class);
        Assertions.assertThat((Object)result).satisfies(new ThrowingConsumer[]{r -> {
            Assertions.assertThat((int)r.count).isEqualTo(3);
            ((ListAssert)Assertions.assertThat(r.items).hasSize(3)).satisfies(new ThrowingConsumer[]{l -> {
                ((ObjectAssert)((ListAssert)Assertions.assertThat((List)l).filteredOn(i -> i.name.equals("status"))).singleElement()).satisfies(new ThrowingConsumer[]{i -> {
                    Assertions.assertThat((long)i.size).isEqualTo((long)status.length());
                    Assertions.assertThat((String)i.fileName).isNullOrEmpty();
                    Assertions.assertThat((boolean)i.isFileItem).isFalse();
                    Assertions.assertThat(i.headers).contains(new Map.Entry[]{Assertions.entry((Object)"Content-Type", List.of("text/plain; charset=US-ASCII"))});
                }});
                ((ObjectAssert)((ListAssert)Assertions.assertThat((List)l).filteredOn(i -> i.name.equals("htmlFile"))).singleElement()).satisfies(new ThrowingConsumer[]{i -> {
                    Assertions.assertThat((long)i.size).isEqualTo(Files.size(this.HTML_FILE.toPath()));
                    Assertions.assertThat((String)i.fileName).isEqualTo("test.html");
                    Assertions.assertThat((boolean)i.isFileItem).isTrue();
                    Assertions.assertThat(i.headers).contains(new Map.Entry[]{Assertions.entry((Object)"Content-Type", List.of("text/html"))});
                }});
                ((ObjectAssert)((ListAssert)Assertions.assertThat((List)l).filteredOn(i -> i.name.equals("xmlFile"))).singleElement()).satisfies(new ThrowingConsumer[]{i -> {
                    Assertions.assertThat((long)i.size).isEqualTo(Files.size(this.XML_FILE.toPath()));
                    Assertions.assertThat((String)i.fileName).isEqualTo("test.xml");
                    Assertions.assertThat((boolean)i.isFileItem).isTrue();
                    Assertions.assertThat(i.headers).contains(new Map.Entry[]{Assertions.entry((Object)"Content-Type", List.of("text/xml"))});
                }});
            }});
        }});
    }

    public static class Result {
        public List<Item> items;
        public int count;

        public Result() {
        }

        public Result(List<Item> items, int count) {
            this.items = items;
            this.count = count;
        }
    }

    public static class Item {
        public final String name;
        public final long size;
        public final String charset;
        public final String fileName;
        public final boolean isFileItem;
        public final Map<String, List<String>> headers;

        public Item(String name, long size, String charset, String fileName, boolean isFileItem, Map<String, List<String>> headers) {
            this.name = name;
            this.size = size;
            this.charset = charset;
            this.fileName = fileName;
            this.isFileItem = isFileItem;
            this.headers = headers;
        }
    }

    @Path(value="/test")
    public static class Resource {
        @POST
        @Consumes(value={"multipart/form-data"})
        @Produces(value={"application/json"})
        @Path(value="{count}")
        public String hello(MultipartFormDataInput input, int count) throws IOException {
            Map map = input.getValues();
            ArrayList<Item> items = new ArrayList<Item>();
            for (Map.Entry entry : map.entrySet()) {
                for (FormValue value : (Collection)entry.getValue()) {
                    items.add(new Item((String)entry.getKey(), value.isFileItem() ? value.getFileItem().getFileSize() : (long)value.getValue().length(), value.getCharset(), value.getFileName(), value.isFileItem(), (Map<String, List<String>>)value.getHeaders()));
                }
            }
            return new ObjectMapper().writeValueAsString((Object)new Result(items, count));
        }
    }
}

