/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.multipart;

import io.quarkus.resteasy.reactive.server.test.multipart.FormData;
import io.quarkus.resteasy.reactive.server.test.multipart.FormDataBase;
import io.quarkus.resteasy.reactive.server.test.multipart.FormDataSameFileName;
import io.quarkus.resteasy.reactive.server.test.multipart.MultipartResource;
import io.quarkus.resteasy.reactive.server.test.multipart.OtherFormData;
import io.quarkus.resteasy.reactive.server.test.multipart.OtherFormDataBase;
import io.quarkus.resteasy.reactive.server.test.multipart.Status;
import io.quarkus.resteasy.reactive.server.test.multipart.other.OtherPackageFormDataBase;
import io.quarkus.test.QuarkusDevModeTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.File;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class MultipartFormInputDevModeTest {
    @RegisterExtension
    static QuarkusDevModeTest TEST = new QuarkusDevModeTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{FormDataBase.class, OtherPackageFormDataBase.class, FormData.class, Status.class, FormDataSameFileName.class, OtherFormData.class, OtherFormDataBase.class, MultipartResource.class});
        }
    });
    private final File HTML_FILE = new File("./src/test/resources/test.html");
    private final File XML_FILE = new File("./src/test/resources/test.html");
    private final File TXT_FILE = new File("./src/test/resources/lorem.txt");

    @Test
    public void test() {
        this.doTest("simple");
        this.doTest("simple");
        TEST.modifySourceFile(MultipartResource.class.getSimpleName() + ".java", (Function)new Function<String, String>(){

            @Override
            public String apply(String s) {
                return s.replace("/simple", "/simple2");
            }
        });
        this.doTest("simple2");
        this.doTest("simple2");
        TEST.modifySourceFile(MultipartResource.class.getSimpleName() + ".java", (Function)new Function<String, String>(){

            @Override
            public String apply(String s) {
                return s.replace("/simple2", "/simple");
            }
        });
        this.doTest("simple");
        this.doTest("simple");
    }

    private void doTest(String path) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().multiPart("name", "Alice").multiPart("active", "true").multiPart("num", "25").multiPart("status", "WORKING").multiPart("htmlFile", this.HTML_FILE, "text/html").multiPart("xmlFile", this.XML_FILE, "text/xml").multiPart("txtFile", this.TXT_FILE, "text/plain").accept("text/plain").when().post("/multipart/" + path + "/2", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"Alice - true - 50 - WORKING - true - true - true"), new Matcher[0]);
    }
}

