/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.multipart;

import io.quarkus.resteasy.reactive.server.test.multipart.AbstractMultipartTest;
import io.quarkus.resteasy.reactive.server.test.multipart.FormData;
import io.quarkus.resteasy.reactive.server.test.multipart.FormDataBase;
import io.quarkus.resteasy.reactive.server.test.multipart.FormDataSameFileName;
import io.quarkus.resteasy.reactive.server.test.multipart.MultipartResource;
import io.quarkus.resteasy.reactive.server.test.multipart.OtherFormData;
import io.quarkus.resteasy.reactive.server.test.multipart.OtherFormDataBase;
import io.quarkus.resteasy.reactive.server.test.multipart.OtherMultipartResource;
import io.quarkus.resteasy.reactive.server.test.multipart.Status;
import io.quarkus.resteasy.reactive.server.test.multipart.other.OtherPackageFormDataBase;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Supplier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class MultipartInputTest
extends AbstractMultipartTest {
    private static final Path uploadDir = Paths.get("file-uploads", new String[0]);
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{FormDataBase.class, OtherPackageFormDataBase.class, FormData.class, Status.class, OtherFormData.class, FormDataSameFileName.class, OtherFormDataBase.class, MultipartResource.class, OtherMultipartResource.class})).addAsResource((Asset)new StringAsset("quarkus.http.body.delete-uploaded-files-on-end=false\nquarkus.http.body.uploads-directory=" + uploadDir.toString() + "\n"), "application.properties");
        }
    });
    private final File HTML_FILE = new File("./src/test/resources/test.html");
    private final File HTML_FILE2 = new File("./src/test/resources/test2.html");
    private final File XML_FILE = new File("./src/test/resources/test.html");
    private final File TXT_FILE = new File("./src/test/resources/lorem.txt");
    private final String TXT = "lorem ipsum";
    private final String XML = "<note></note>";
    private final String HTML = "<!DOCTYPE html><html></html>";

    @BeforeEach
    public void assertEmptyUploads() {
        Assertions.assertTrue((boolean)this.isDirectoryEmpty(uploadDir));
    }

    @AfterEach
    public void clearDirectory() {
        this.clearDirectory(uploadDir);
    }

    @Test
    public void testSimple() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().multiPart("name", "Alice").multiPart("active", "true").multiPart("num", "25").multiPart("status", "WORKING").multiPart("htmlFile", "<!DOCTYPE html><html></html>", "text/html").multiPart("xmlFile", "<note></note>", "text/xml").multiPart("txtFile", "lorem ipsum", "text/plain").accept("text/plain").when().post("/multipart/simple/2", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"Alice - true - 50 - WORKING - true - true - true"), new Matcher[0]);
        Assertions.assertEquals((int)3, (int)uploadDir.toFile().listFiles().length);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().multiPart("name", "something.txt", "Alice".getBytes()).multiPart("active", "true").multiPart("num", "25").multiPart("status", "WORKING").multiPart("htmlFile", "<!DOCTYPE html><html></html>", "text/html").multiPart("xmlFile", "<note></note>", "text/xml").multiPart("txtFile", "lorem ipsum", "text/plain").accept("text/plain").when().post("/multipart/simple/2", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"Alice - true - 50 - WORKING - true - true - true"), new Matcher[0]);
    }

    @Test
    public void testSimpleImplicit() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().multiPart("name", "Alice").multiPart("active", "true").multiPart("num", "25").multiPart("status", "WORKING").multiPart("htmlFile", this.HTML_FILE, "text/html").multiPart("xmlFile", this.XML_FILE, "text/xml").multiPart("txtFile", this.TXT_FILE, "text/plain").accept("text/plain").when().post("/multipart/implicit/simple/2", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"Alice - true - 50 - WORKING - text/html - true - true"), new Matcher[0]);
        Assertions.assertEquals((int)3, (int)uploadDir.toFile().listFiles().length);
    }

    @Test
    public void testSimpleParam() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().multiPart("name", "Alice").multiPart("active", "true").multiPart("num", "25").multiPart("status", "WORKING").multiPart("htmlFile", "<!DOCTYPE html><html></html>", "text/html").multiPart("xmlFile", "<note></note>", "text/xml").multiPart("txtFile", "lorem ipsum", "text/plain").accept("text/plain").when().post("/multipart/param/simple/2", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"Alice - true - 50 - WORKING - true - true - true"), new Matcher[0]);
        Assertions.assertEquals((int)3, (int)uploadDir.toFile().listFiles().length);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().multiPart("name", "something.txt", "Alice".getBytes()).multiPart("active", "true").multiPart("num", "25").multiPart("status", "WORKING").multiPart("htmlFile", "<!DOCTYPE html><html></html>", "text/html").multiPart("xmlFile", "<note></note>", "text/xml").multiPart("txtFile", "lorem ipsum", "text/plain").accept("text/plain").when().post("/multipart/param/simple/2", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"Alice - true - 50 - WORKING - true - true - true"), new Matcher[0]);
    }

    @Test
    public void testBlocking() throws IOException {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().multiPart("name", "Trudy").multiPart("num", "20").multiPart("status", "SLEEPING").multiPart("htmlFile", this.HTML_FILE, "text/html").multiPart("xmlFile", this.XML_FILE, "text/xml").multiPart("txtFile", this.TXT_FILE, "text/plain").accept("text/plain").when().post("/multipart/blocking?times=2", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"Trudy - 40 - SLEEPING"), new Matcher[0])).header("html-size", CoreMatchers.equalTo((Object)this.fileSizeAsStr(this.HTML_FILE)))).header("html-path", CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)this.filePath(this.HTML_FILE))))).header("xml-size", CoreMatchers.equalTo((Object)this.fileSizeAsStr(this.XML_FILE)))).header("xml-path", CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)this.filePath(this.XML_FILE))))).header("txt-size", CoreMatchers.equalTo((Object)this.fileSizeAsStr(this.TXT_FILE)))).header("txt-path", CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)this.filePath(this.TXT_FILE))));
        Assertions.assertEquals((int)3, (int)uploadDir.toFile().listFiles().length);
    }

    @Test
    public void testOther() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().multiPart("first", "foo").multiPart("last", "bar").accept("text/plain").when().post("/otherMultipart/simple", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"foo - bar - final - static"), new Matcher[0]);
        Assertions.assertEquals((int)0, (int)uploadDir.toFile().listFiles().length);
    }

    @Test
    public void testSameName() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().multiPart("active", "false").multiPart("status", "EATING").multiPart("htmlFile", this.HTML_FILE, "text/html").multiPart("htmlFile", this.HTML_FILE2, "text/html").multiPart("xmlFile", this.XML_FILE, "text/xml").multiPart("txtFile", this.TXT_FILE, "text/plain").accept("text/plain").when().post("/multipart/same-name", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"EATING - 2 - 1 - 1"), new Matcher[0]);
        Assertions.assertEquals((int)4, (int)uploadDir.toFile().listFiles().length);
    }

    @Test
    public void testSameNameParam() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().multiPart("active", "false").multiPart("status", "EATING").multiPart("htmlFile", this.HTML_FILE, "text/html").multiPart("htmlFile", this.HTML_FILE2, "text/html").multiPart("xmlFile", this.XML_FILE, "text/xml").multiPart("txtFile", this.TXT_FILE, "text/plain").accept("text/plain").when().post("/multipart/param/same-name", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"EATING - 2 - 1 - 1"), new Matcher[0]);
        Assertions.assertEquals((int)4, (int)uploadDir.toFile().listFiles().length);
    }

    private String filePath(File file) {
        return file.toPath().toAbsolutePath().toString();
    }
}

