/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.multipart;

import io.quarkus.resteasy.reactive.server.test.multipart.AbstractMultipartTest;
import io.quarkus.resteasy.reactive.server.test.multipart.FormDataBase;
import io.quarkus.resteasy.reactive.server.test.multipart.FormDataWithAllUploads;
import io.quarkus.resteasy.reactive.server.test.multipart.MultipartResourceWithAllUploads;
import io.quarkus.resteasy.reactive.server.test.multipart.Status;
import io.quarkus.resteasy.reactive.server.test.multipart.other.OtherPackageFormDataBase;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Supplier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class MultipartInputWithAllUploadsTest
extends AbstractMultipartTest {
    private static final Path uploadDir = Paths.get("file-uploads", new String[0]);
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{FormDataBase.class, OtherPackageFormDataBase.class, FormDataWithAllUploads.class, Status.class, MultipartResourceWithAllUploads.class})).addAsResource((Asset)new StringAsset("quarkus.http.body.delete-uploaded-files-on-end=false\nquarkus.http.body.uploads-directory=" + uploadDir.toString() + "\nquarkus.http.body.multipart.file-content-types=text/xml,custom/content-type\n"), "application.properties");
        }
    });
    private final File HTML_FILE = new File("./src/test/resources/test.html");
    private final File XML_FILE = new File("./src/test/resources/test.html");
    private final File TXT_FILE = new File("./src/test/resources/lorem.txt");

    @BeforeEach
    public void assertEmptyUploads() {
        Assertions.assertTrue((boolean)this.isDirectoryEmpty(uploadDir));
    }

    @AfterEach
    public void clearDirectory() {
        this.clearDirectory(uploadDir);
    }

    @Test
    public void testSimple() throws IOException {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().multiPart("name", "Alice").multiPart("active", "true").multiPart("num", "25").multiPart("status", "WORKING").multiPart("htmlFile", this.HTML_FILE, "text/html").multiPart("xmlFile", this.XML_FILE, "text/xml").multiPart("txtFile", this.TXT_FILE, "text/plain").accept("text/plain").when().post("/multipart-all/simple/2", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"Alice - true - 50 - WORKING - 3 - text/plain"), new Matcher[0]);
        Assertions.assertEquals((int)3, (int)uploadDir.toFile().listFiles().length);
    }

    @Test
    public void testSimpleParam() throws IOException {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().multiPart("name", "Alice").multiPart("active", "true").multiPart("num", "25").multiPart("status", "WORKING").multiPart("htmlFile", this.HTML_FILE, "text/html").multiPart("xmlFile", this.XML_FILE, "text/xml").multiPart("txtFile", this.TXT_FILE, "text/plain").accept("text/plain").when().post("/multipart-all/param/simple/2", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"Alice - true - 50 - WORKING - 3 - text/plain"), new Matcher[0]);
        Assertions.assertEquals((int)3, (int)uploadDir.toFile().listFiles().length);
    }
}

