/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.multipart;

import io.quarkus.resteasy.reactive.server.test.multipart.MultipartOutputFileResponse;
import io.quarkus.resteasy.reactive.server.test.multipart.MultipartOutputMultipleFileDownloadResponse;
import io.quarkus.resteasy.reactive.server.test.multipart.MultipartOutputMultipleFileResponse;
import io.quarkus.resteasy.reactive.server.test.multipart.MultipartOutputResponse;
import io.quarkus.resteasy.reactive.server.test.multipart.MultipartOutputSingleFileDownloadResponse;
import io.quarkus.resteasy.reactive.server.test.multipart.PathFileDownload;
import io.quarkus.resteasy.reactive.server.test.multipart.Status;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import org.jboss.resteasy.reactive.RestResponse;
import org.jboss.resteasy.reactive.server.multipart.MultipartFormDataOutput;

@Path(value="/multipart/output")
public class MultipartOutputResource {
    public static final String RESPONSE_NAME = "a name";
    public static final String RESPONSE_FILENAME = "a filename";
    public static final String RESPONSE_SURNAME = "a surname";
    public static final Status RESPONSE_STATUS = Status.WORKING;
    public static final List<String> RESPONSE_VALUES = List.of("one", "two");
    public static final boolean RESPONSE_ACTIVE = true;
    private static final long ONE_GIGA = 0x40000000L;
    private final File TXT_FILE = new File("./src/test/resources/lorem.txt");
    private final File XML_FILE = new File("./src/test/resources/test.xml");

    @GET
    @Path(value="/simple")
    @Produces(value={"multipart/form-data"})
    public MultipartOutputResponse simple() {
        MultipartOutputResponse response = new MultipartOutputResponse();
        response.setName(RESPONSE_NAME);
        response.setSurname(RESPONSE_SURNAME);
        response.setStatus(RESPONSE_STATUS);
        response.setValues(RESPONSE_VALUES);
        response.active = true;
        return response;
    }

    @GET
    @Path(value="/rest-response")
    @Produces(value={"multipart/form-data"})
    public RestResponse<MultipartOutputResponse> restResponse() {
        MultipartOutputResponse response = new MultipartOutputResponse();
        response.setName(RESPONSE_NAME);
        response.setSurname(RESPONSE_SURNAME);
        response.setStatus(RESPONSE_STATUS);
        response.setValues(RESPONSE_VALUES);
        response.active = true;
        return RestResponse.ResponseBuilder.ok((Object)response).header("foo", (Object)"bar").build();
    }

    @GET
    @Path(value="/with-form-data")
    @Produces(value={"multipart/form-data"})
    public RestResponse<MultipartFormDataOutput> withFormDataOutput() {
        MultipartFormDataOutput form = new MultipartFormDataOutput();
        form.addFormData("name", (Object)RESPONSE_NAME, MediaType.TEXT_PLAIN_TYPE);
        form.addFormData("part-with-filename", (Object)RESPONSE_FILENAME, MediaType.TEXT_PLAIN_TYPE, "file.txt");
        form.addFormData("part-with-filename", (Object)RESPONSE_FILENAME, MediaType.TEXT_PLAIN_TYPE, "file2.txt");
        form.addFormData("custom-surname", (Object)RESPONSE_SURNAME, MediaType.TEXT_PLAIN_TYPE);
        form.addFormData("custom-status", (Object)RESPONSE_STATUS, MediaType.TEXT_PLAIN_TYPE).getHeaders().putSingle((Object)"extra-header", (Object)"extra-value");
        form.addFormData("values", RESPONSE_VALUES, MediaType.TEXT_PLAIN_TYPE);
        form.addFormData("active", (Object)true, MediaType.TEXT_PLAIN_TYPE);
        return RestResponse.ResponseBuilder.ok((Object)form).header("foo", (Object)"bar").build();
    }

    @GET
    @Path(value="/string")
    @Produces(value={"multipart/form-data"})
    public String usingString() {
        return RESPONSE_NAME;
    }

    @GET
    @Path(value="/with-file")
    @Produces(value={"multipart/form-data"})
    public MultipartOutputFileResponse file() {
        MultipartOutputFileResponse response = new MultipartOutputFileResponse();
        response.name = RESPONSE_NAME;
        response.file = this.TXT_FILE;
        return response;
    }

    @GET
    @Path(value="/with-multiple-file")
    @Produces(value={"multipart/form-data"})
    public MultipartOutputMultipleFileResponse multipleFile() {
        MultipartOutputMultipleFileResponse response = new MultipartOutputMultipleFileResponse();
        response.name = RESPONSE_NAME;
        response.files = List.of(this.TXT_FILE, this.XML_FILE);
        return response;
    }

    @GET
    @Path(value="/with-single-file-download")
    @Produces(value={"multipart/form-data"})
    public MultipartOutputSingleFileDownloadResponse singleDownloadFile() {
        MultipartOutputSingleFileDownloadResponse response = new MultipartOutputSingleFileDownloadResponse();
        response.file = new PathFileDownload("one", this.XML_FILE);
        return response;
    }

    @GET
    @Path(value="/with-multiple-file-download")
    @Produces(value={"multipart/form-data"})
    public MultipartOutputMultipleFileDownloadResponse multipleDownloadFile() {
        MultipartOutputMultipleFileDownloadResponse response = new MultipartOutputMultipleFileDownloadResponse();
        response.name = RESPONSE_NAME;
        response.files = List.of(new PathFileDownload(this.TXT_FILE), new PathFileDownload(this.XML_FILE));
        return response;
    }

    @GET
    @Path(value="/with-large-file")
    @Produces(value={"multipart/form-data"})
    public MultipartOutputFileResponse largeFile() throws IOException {
        File largeFile = File.createTempFile("rr-large-file", ".tmp");
        largeFile.deleteOnExit();
        RandomAccessFile f = new RandomAccessFile(largeFile, "rw");
        f.setLength(0x40000000L);
        MultipartOutputFileResponse response = new MultipartOutputFileResponse();
        response.name = RESPONSE_NAME;
        response.file = largeFile;
        return response;
    }

    @GET
    @Path(value="/with-null-fields")
    @Produces(value={"multipart/form-data"})
    public MultipartOutputFileResponse nullFields() {
        MultipartOutputFileResponse response = new MultipartOutputFileResponse();
        response.name = null;
        response.file = null;
        return response;
    }
}

