/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.multipart;

import io.quarkus.resteasy.reactive.server.test.multipart.AbstractMultipartTest;
import io.quarkus.resteasy.reactive.server.test.multipart.FormDataBase;
import io.quarkus.resteasy.reactive.server.test.multipart.MultipartOutputFileResponse;
import io.quarkus.resteasy.reactive.server.test.multipart.MultipartOutputMultipleFileDownloadResponse;
import io.quarkus.resteasy.reactive.server.test.multipart.MultipartOutputMultipleFileResponse;
import io.quarkus.resteasy.reactive.server.test.multipart.MultipartOutputResource;
import io.quarkus.resteasy.reactive.server.test.multipart.MultipartOutputResponse;
import io.quarkus.resteasy.reactive.server.test.multipart.MultipartOutputSingleFileDownloadResponse;
import io.quarkus.resteasy.reactive.server.test.multipart.PathFileDownload;
import io.quarkus.resteasy.reactive.server.test.multipart.Status;
import io.quarkus.resteasy.reactive.server.test.multipart.other.OtherPackageFormDataBase;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.ExtractableResponse;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledIfSystemProperty;
import org.junit.jupiter.api.extension.RegisterExtension;

public class MultipartOutputUsingBlockingEndpointsTest
extends AbstractMultipartTest {
    private static final String EXPECTED_CONTENT_DISPOSITION_PART = "Content-Disposition: form-data; name=\"%s\"";
    private static final String EXPECTED_CONTENT_DISPOSITION_FILE_PART = "Content-Disposition: form-data; name=\"%s\"; filename=\"%s\"";
    private static final String EXPECTED_CONTENT_TYPE_PART = "Content-Type: %s";
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer(() -> (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{MultipartOutputResource.class, MultipartOutputResponse.class, MultipartOutputFileResponse.class, MultipartOutputMultipleFileResponse.class, MultipartOutputMultipleFileDownloadResponse.class, MultipartOutputSingleFileDownloadResponse.class, Status.class, FormDataBase.class, OtherPackageFormDataBase.class, PathFileDownload.class}));

    @Test
    public void testSimple() {
        String response = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/multipart/output/simple", (Object[])new Object[0]).then()).contentType(ContentType.MULTIPART)).statusCode(200)).extract().asString();
        this.assertContainsValue(response, "name", "text/plain", "a name");
        this.assertContainsValue(response, "custom-surname", "text/plain", "a surname");
        this.assertContainsValue(response, "custom-status", "text/plain", (Object)MultipartOutputResource.RESPONSE_STATUS);
        this.assertContainsValue(response, "active", "text/plain", true);
        this.assertContainsValue(response, "values", "text/plain", "[one, two]");
        this.assertContainsValue(response, "num", "text/plain", "0");
    }

    @Test
    public void testRestResponse() {
        String response = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/multipart/output/rest-response", (Object[])new Object[0]).then()).contentType(ContentType.MULTIPART)).statusCode(200)).header("foo", "bar")).extract().asString();
        this.assertContainsValue(response, "name", "text/plain", "a name");
        this.assertContainsValue(response, "custom-surname", "text/plain", "a surname");
        this.assertContainsValue(response, "custom-status", "text/plain", (Object)MultipartOutputResource.RESPONSE_STATUS);
        this.assertContainsValue(response, "active", "text/plain", true);
        this.assertContainsValue(response, "values", "text/plain", "[one, two]");
        this.assertContainsValue(response, "num", "text/plain", "0");
    }

    @Test
    public void testWithFormData() {
        ExtractableResponse extractable = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/multipart/output/with-form-data", (Object[])new Object[0]).then()).contentType(ContentType.MULTIPART)).statusCode(200)).extract();
        String body = extractable.asString();
        this.assertContainsValue(body, "name", "text/plain", "a name");
        this.assertContainsValue(body, "part-with-filename", "text/plain", "filename=\"file.txt\"");
        this.assertContainsValue(body, "part-with-filename", "text/plain", "filename=\"file2.txt\"");
        this.assertContainsValue(body, "custom-surname", "text/plain", "a surname");
        this.assertContainsValue(body, "custom-status", "text/plain", (Object)MultipartOutputResource.RESPONSE_STATUS);
        this.assertContainsValue(body, "active", "text/plain", true);
        this.assertContainsValue(body, "values", "text/plain", "[one, two]");
        Assertions.assertThat((String)extractable.header("Content-Type")).contains(new CharSequence[]{"boundary="});
    }

    @Test
    public void testString() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/multipart/output/string", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"a name"), new Matcher[0]);
    }

    @Test
    public void testWithFile() {
        String response = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/multipart/output/with-file", new Object[0])).then()).contentType(ContentType.MULTIPART)).statusCode(200)).extract().asString();
        this.assertContainsValue(response, "name", "text/plain", "a name");
        this.assertContainsFile(response, "file", "application/octet-stream", "lorem.txt");
    }

    @Test
    public void testWithSingleFileDownload() {
        String response = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/multipart/output/with-single-file-download", new Object[0])).then()).contentType(ContentType.MULTIPART)).statusCode(200)).extract().asString();
        this.assertContainsFile(response, "one", "application/octet-stream", "test.xml");
    }

    @Test
    public void testWithMultipleFiles() {
        String response = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/multipart/output/with-multiple-file", new Object[0])).then()).contentType(ContentType.MULTIPART)).statusCode(200)).extract().asString();
        this.assertContainsValue(response, "name", "text/plain", "a name");
        this.assertContainsFile(response, "files", "application/octet-stream", "lorem.txt");
        this.assertContainsFile(response, "files", "application/octet-stream", "test.xml");
    }

    @Test
    public void testWithMultipleFileDownload() {
        String response = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/multipart/output/with-multiple-file-download", new Object[0])).then()).contentType(ContentType.MULTIPART)).statusCode(200)).extract().asString();
        this.assertContainsValue(response, "name", "text/plain", "a name");
        this.assertContainsFile(response, "files", "application/octet-stream", "lorem.txt");
        this.assertContainsFile(response, "files", "application/octet-stream", "test.xml");
    }

    @EnabledIfSystemProperty(named="test-resteasy-reactive-large-files", matches="true")
    @Test
    public void testWithLargeFiles() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/multipart/output/with-large-file", new Object[0])).then()).contentType(ContentType.MULTIPART)).statusCode(200);
    }

    @Test
    public void testWithNullFields() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/multipart/output/with-null-fields", new Object[0])).then()).contentType(ContentType.MULTIPART)).log().all()).statusCode(200);
    }

    private void assertContainsFile(String response, String name, String contentType, String fileName) {
        Object[] lines = response.split("--");
        Assertions.assertThat((Object[])lines).anyMatch(line -> line.contains(String.format(EXPECTED_CONTENT_DISPOSITION_FILE_PART, name, fileName)) && line.contains(String.format(EXPECTED_CONTENT_TYPE_PART, contentType)));
    }

    private void assertContainsValue(String response, String name, String contentType, Object value) {
        Object[] lines = response.split("--");
        Assertions.assertThat((Object[])lines).anyMatch(line -> line.contains(String.format(EXPECTED_CONTENT_DISPOSITION_PART, name)) && line.contains(String.format(EXPECTED_CONTENT_TYPE_PART, contentType)) && line.contains(value.toString()));
    }
}

