/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.multipart;

import io.quarkus.resteasy.reactive.server.test.multipart.FormData;
import io.quarkus.resteasy.reactive.server.test.multipart.FormDataSameFileName;
import io.quarkus.resteasy.reactive.server.test.multipart.Status;
import io.quarkus.runtime.BlockingOperationControl;
import io.smallrye.common.annotation.Blocking;
import io.smallrye.common.annotation.NonBlocking;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.List;
import org.jboss.resteasy.reactive.PartType;
import org.jboss.resteasy.reactive.RestForm;
import org.jboss.resteasy.reactive.RestQuery;
import org.jboss.resteasy.reactive.multipart.FileUpload;

@Path(value="/multipart")
public class MultipartResource {
    @POST
    @Produces(value={"text/plain"})
    @Consumes(value={"multipart/form-data"})
    @Path(value="/simple/{times}")
    @NonBlocking
    public String simple(@BeanParam FormData formData, Integer times) {
        if (BlockingOperationControl.isBlockingAllowed()) {
            throw new RuntimeException("should not have dispatched");
        }
        return formData.getName() + " - " + formData.active + " - " + times * formData.getNum() + " - " + formData.getStatus() + " - " + Files.exists(formData.getHtmlPart().filePath(), new LinkOption[0]) + " - " + Files.exists(formData.xmlPart, new LinkOption[0]) + " - " + formData.txtFile.exists();
    }

    @POST
    @Path(value="/implicit/simple/{times}")
    @NonBlocking
    public String simpleImplicit(FormData formData, Integer times) {
        if (BlockingOperationControl.isBlockingAllowed()) {
            throw new RuntimeException("should not have dispatched");
        }
        return formData.getName() + " - " + formData.active + " - " + times * formData.getNum() + " - " + formData.getStatus() + " - " + formData.getHtmlPart().contentType() + " - " + Files.exists(formData.xmlPart, new LinkOption[0]) + " - " + formData.txtFile.exists();
    }

    @POST
    @Produces(value={"text/plain"})
    @Consumes(value={"multipart/form-data"})
    @Path(value="/param/simple/{times}")
    @NonBlocking
    public String simple(@RestForm String name, @RestForm @PartType(value="text/plain") Status status, @RestForm(value="htmlFile") FileUpload htmlPart, @RestForm(value="xmlFile") java.nio.file.Path xmlPart, @RestForm File txtFile, @RestForm @PartType(value="text/plain") boolean active, @RestForm @PartType(value="text/plain") int num, Integer times) {
        if (BlockingOperationControl.isBlockingAllowed()) {
            throw new RuntimeException("should not have dispatched");
        }
        return name + " - " + active + " - " + times * num + " - " + status + " - " + Files.exists(htmlPart.filePath(), new LinkOption[0]) + " - " + Files.exists(xmlPart, new LinkOption[0]) + " - " + txtFile.exists();
    }

    @POST
    @Blocking
    @Produces(value={"text/plain"})
    @Consumes(value={"multipart/form-data"})
    @Path(value="/blocking")
    public Response blocking(@DefaultValue(value="1") @RestQuery Integer times, FormData formData) throws IOException {
        if (!BlockingOperationControl.isBlockingAllowed()) {
            throw new RuntimeException("should have dispatched");
        }
        return Response.ok((Object)(formData.getName() + " - " + times * formData.getNum() + " - " + formData.getStatus())).header("html-size", (Object)formData.getHtmlPart().size()).header("html-path", (Object)formData.getHtmlPart().uploadedFile().toAbsolutePath().toString()).header("xml-size", (Object)Files.readAllBytes(formData.xmlPart).length).header("xml-path", (Object)formData.xmlPart.toAbsolutePath().toString()).header("txt-size", (Object)Files.readAllBytes(formData.txtFile.toPath()).length).header("txt-path", (Object)formData.txtFile.toPath().toAbsolutePath().toString()).build();
    }

    @POST
    @Produces(value={"text/plain"})
    @Consumes(value={"multipart/form-data"})
    @Path(value="/same-name")
    public String sameName(FormDataSameFileName formData) {
        if (!BlockingOperationControl.isBlockingAllowed()) {
            throw new RuntimeException("should have dispatched");
        }
        return formData.status + " - " + formData.getHtmlFiles().size() + " - " + formData.txtFiles.size() + " - " + formData.xmlFiles.size();
    }

    @POST
    @Produces(value={"text/plain"})
    @Consumes(value={"multipart/form-data"})
    @Path(value="/param/same-name")
    public String sameName(@RestForm @PartType(value="text/plain") Status status, @RestForm(value="htmlFile") List<File> htmlFiles, @RestForm(value="txtFile") List<FileUpload> txtFiles, @RestForm(value="xmlFile") List<java.nio.file.Path> xmlFiles) {
        if (!BlockingOperationControl.isBlockingAllowed()) {
            throw new RuntimeException("should have dispatched");
        }
        return status + " - " + htmlFiles.size() + " - " + txtFiles.size() + " - " + xmlFiles.size();
    }

    @POST
    @Produces(value={"text/plain"})
    @Consumes(value={"multipart/form-data"})
    @Path(value="/optional")
    @NonBlocking
    public String optional(FormData formData) {
        if (BlockingOperationControl.isBlockingAllowed()) {
            throw new RuntimeException("should not have dispatched");
        }
        return formData.getName() + " - " + formData.active + " - " + formData.getNum() + " - " + formData.getStatus() + " - " + (formData.getHtmlPart() != null) + " - " + (formData.xmlPart != null) + " - " + (formData.txtFile != null);
    }
}

