/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.multipart;

import io.quarkus.resteasy.reactive.server.test.multipart.AbstractMultipartTest;
import io.quarkus.resteasy.reactive.server.test.multipart.FormData;
import io.quarkus.resteasy.reactive.server.test.multipart.FormDataBase;
import io.quarkus.resteasy.reactive.server.test.multipart.Status;
import io.quarkus.resteasy.reactive.server.test.multipart.other.OtherPackageFormDataBase;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.function.Supplier;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

@Disabled(value="flaky")
public class TooLargeFormAttributeMultipartFormInputTest
extends AbstractMultipartTest {
    private static final java.nio.file.Path uploadDir = Paths.get("file-uploads", new String[0]);
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{Resource.class, Status.class, FormDataBase.class, OtherPackageFormDataBase.class, FormData.class})).addAsResource((Asset)new StringAsset("quarkus.http.body.delete-uploaded-files-on-end=false\nquarkus.http.body.uploads-directory=" + uploadDir.toString() + "\n"), "application.properties");
        }
    });
    private final File FORM_ATTR_SOURCE_FILE = new File("./src/test/resources/larger-than-default-form-attribute.txt");
    private final File HTML_FILE = new File("./src/test/resources/test.html");
    private final File XML_FILE = new File("./src/test/resources/test.html");
    private final File TXT_FILE = new File("./src/test/resources/lorem.txt");

    @BeforeEach
    public void assertEmptyUploads() {
        Assertions.assertTrue((boolean)this.isDirectoryEmpty(uploadDir));
    }

    @AfterEach
    public void clearDirectory() {
        this.clearDirectory(uploadDir);
    }

    @Test
    public void test() throws IOException {
        String fileContents = new String(Files.readAllBytes(this.FORM_ATTR_SOURCE_FILE.toPath()), StandardCharsets.UTF_8);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 10; ++i) {
            sb.append(fileContents);
        }
        fileContents = sb.toString();
        Assertions.assertTrue((fileContents.length() > 8192 ? 1 : 0) != 0);
        ((ValidatableResponse)((Response)RestAssured.given().multiPart("active", "true").multiPart("num", "25").multiPart("status", "WORKING").multiPart("htmlFile", this.HTML_FILE, "text/html").multiPart("xmlFile", this.XML_FILE, "text/xml").multiPart("txtFile", this.TXT_FILE, "text/plain").multiPart("name", fileContents).accept("text/plain").when().post("/test", new Object[0])).then()).statusCode(413);
        this.awaitUploadDirectoryToEmpty(uploadDir);
    }

    @Path(value="/test")
    public static class Resource {
        @POST
        @Consumes(value={"multipart/form-data"})
        @Produces(value={"text/plain"})
        public String hello(@BeanParam FormData data) {
            return data.getName();
        }
    }
}

