/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.preconditions;

import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import java.time.Instant;
import java.util.Date;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class DatePreconditionTests {
    @RegisterExtension
    static final QuarkusUnitTest config = new QuarkusUnitTest().withApplicationRoot(jar -> jar.addClasses(new Class[]{Resource.class}));
    static final Date date = new Date(Date.from(Instant.parse("2007-12-03T10:15:30.24Z")).getTime()){};

    @Test
    public void test() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/preconditions", (Object[])new Object[0]).then()).statusCode(200)).header("Last-Modified", "Mon, 03 Dec 2007 10:15:30 GMT")).body(Matchers.equalTo((Object)"foo"), new Matcher[0]);
        ((ValidatableResponse)((io.restassured.response.Response)RestAssured.with().header("If-Modified-Since", (Object)"Mon, 03 Dec 2007 10:15:30 GMT", new Object[0]).get("/preconditions", new Object[0])).then()).statusCode(304);
    }

    @Path(value="/preconditions")
    public static class Resource {
        @GET
        public Response get(Request request) {
            Response.ResponseBuilder resp = request.evaluatePreconditions(date);
            if (resp != null) {
                return resp.build();
            }
            return Response.ok((Object)"foo").lastModified(date).build();
        }
    }

    public static class Something {
    }
}

