/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.resource.basic;

import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class AbortFilterWithLargePayloadTest {
    @RegisterExtension
    static QuarkusUnitTest testExtension = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            JavaArchive war = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
            war.addClasses(new Class[]{TestResource.class, AbortingFilter.class});
            return war;
        }
    });

    @Test
    public void test() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/test", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"hello"), new Matcher[0]);
        Response response = (Response)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().header("abort", (Object)"true", new Object[0]).get("/test", new Object[0])).then()).statusCode(999)).extract().response();
        Assertions.assertEquals((int)30464, (int)response.body().asByteArray().length);
    }

    @Provider
    @PreMatching
    public static class AbortingFilter
    implements ContainerRequestFilter {
        public void filter(ContainerRequestContext requestContext) throws IOException {
            if (requestContext.getHeaderString("abort") != null) {
                requestContext.abortWith(jakarta.ws.rs.core.Response.status((int)999).type("application/octet-stream").entity((Object)new byte[30464]).build());
            }
        }
    }

    @Path(value="/test")
    public static class TestResource {
        @GET
        public String hello() {
            return "hello";
        }
    }
}

