/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.resource.basic;

import io.quarkus.builder.BuildChainBuilder;
import io.quarkus.builder.BuildContext;
import io.quarkus.builder.BuildStep;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.resteasy.reactive.server.spi.AllowNotRestParametersBuildItem;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.MixedParameterResource;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.function.Consumer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

@DisplayName(value="Allow Not RESTEasy Method Parameters")
public class AllowNotResteasyParametersTest {
    @RegisterExtension
    static QuarkusUnitTest quarkusUnitTest = new QuarkusUnitTest().addBuildChainCustomizer((Consumer)new Consumer<BuildChainBuilder>(){

        @Override
        public void accept(BuildChainBuilder buildChainBuilder) {
            buildChainBuilder.addBuildStep(new BuildStep(){

                public void execute(BuildContext context) {
                    context.produce((BuildItem)new AllowNotRestParametersBuildItem());
                }
            }).produces(AllowNotRestParametersBuildItem.class).build();
        }
    }).withApplicationRoot(jar -> jar.addClass(MixedParameterResource.class));

    @Test
    @DisplayName(value="Test Resource Method with one param not related to RESTEasy")
    public void shouldOkEvenNotResteasyParameterPresence() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("value").post("/" + MixedParameterResource.class.getSimpleName() + "/mixed?foo=bar", new Object[0])).then()).statusCode(200)).body(CoreMatchers.is((Object)"bar.value"), new Matcher[0]);
    }

    @Test
    @DisplayName(value="Test Resource Method with only one param not related to RESTEasy")
    public void shouldOkEvenNotResteasySingleParameterPresence() {
        ((ValidatableResponse)((Response)RestAssured.given().body("value").get("/" + MixedParameterResource.class.getSimpleName() + "/single", new Object[0])).then()).statusCode(200);
    }
}

