/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.resource.basic;

import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.ClassLevelMediaTypeResource;
import io.quarkus.resteasy.reactive.server.test.simple.PortProviderUtil;
import io.quarkus.test.QuarkusUnitTest;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.util.function.Supplier;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

@DisplayName(value="Class Level Media Type Test")
public class ClassLevelMediaTypeTest {
    private static Client client;
    @RegisterExtension
    static QuarkusUnitTest testExtension;

    @BeforeAll
    public static void init() {
        client = ClientBuilder.newClient();
    }

    @AfterAll
    public static void after() throws Exception {
        client.close();
        client = null;
    }

    @Test
    @DisplayName(value="Test Application Json Media Type")
    public void testApplicationJsonMediaType() {
        WebTarget base = client.target(this.generateURL("/test"));
        System.err.println(base.getClass());
        try {
            Response response = base.request().get();
            Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
            String body = (String)response.readEntity(String.class);
            Assertions.assertEquals((Object)response.getHeaderString("Content-Type"), (Object)"application/json;charset=UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String generateURL(String path) {
        return PortProviderUtil.generateURL(path);
    }

    static {
        testExtension = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

            @Override
            public JavaArchive get() {
                JavaArchive war = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
                war.addClasses(new Class[]{PortProviderUtil.class, ClassLevelMediaTypeResource.class});
                return war;
            }
        });
    }
}

