/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.resource.basic;

import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.HttpHeadersResource;
import io.quarkus.resteasy.reactive.server.test.simple.PortProviderUtil;
import io.quarkus.test.QuarkusUnitTest;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.Response;
import java.util.function.Supplier;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

@DisplayName(value="Http Headers Test")
public class HttpHeadersTest {
    static Client client;
    @RegisterExtension
    static QuarkusUnitTest testExtension;

    @BeforeAll
    public static void init() {
        client = ClientBuilder.newClient();
    }

    @AfterAll
    public static void close() {
        client.close();
    }

    private static String generateURL(String path) {
        return PortProviderUtil.generateURL(path, HttpHeadersTest.class.getSimpleName());
    }

    @Test
    @DisplayName(value="Request Headers Test")
    public void RequestHeadersTest() throws Exception {
        String errorMessage = "Wrong content of response";
        Response response = client.target(HttpHeadersTest.generateURL("/HeadersTest/headers")).request().header("Accept", (Object)"text/plain, text/html, text/html;level=1, */*").header("Content-Type", (Object)"application/xml;charset=utf8").get();
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        String content = (String)response.readEntity(String.class);
        Assertions.assertTrue((-1 < content.indexOf("Accept:") ? 1 : 0) != 0);
        Assertions.assertTrue((-1 < content.indexOf("Content-Type:") ? 1 : 0) != 0);
        Assertions.assertTrue((-1 < content.indexOf("application/xml") ? 1 : 0) != 0);
        Assertions.assertTrue((-1 < content.indexOf("charset=utf8") ? 1 : 0) != 0);
        Assertions.assertTrue((-1 < content.indexOf("text/html") ? 1 : 0) != 0);
        Assertions.assertTrue((-1 < content.indexOf("*/*") ? 1 : 0) != 0);
        response.close();
    }

    static {
        testExtension = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

            @Override
            public JavaArchive get() {
                JavaArchive war = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
                war.addClasses(new Class[]{PortProviderUtil.class, HttpHeadersResource.class});
                return war;
            }
        });
    }
}

