/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.resource.basic;

import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.InheritanceAbstractParentImplResource;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.InheritanceAbstractParentResource;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.InheritanceParentResource;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.InheritanceParentResourceImpl;
import io.quarkus.resteasy.reactive.server.test.simple.PortProviderUtil;
import io.quarkus.test.QuarkusUnitTest;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.Response;
import java.util.function.Supplier;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

@DisplayName(value="Inheritance Test")
public class InheritanceTest {
    private static Client client;
    @RegisterExtension
    static QuarkusUnitTest testExtension;

    private String generateURL(String path) {
        return PortProviderUtil.generateURL(path, InheritanceTest.class.getSimpleName());
    }

    @BeforeAll
    public static void beforeSub() {
        client = ClientBuilder.newClient();
    }

    @AfterAll
    public static void afterSub() {
        client.close();
    }

    @Test
    @DisplayName(value="Test 1")
    public void Test1() throws Exception {
        Invocation.Builder builder = client.target(this.generateURL("/InheritanceTest")).request();
        builder.header("Accept", (Object)"text/plain");
        Response response = builder.get();
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        Assertions.assertEquals((Object)response.readEntity(String.class), (Object)"First");
    }

    @Test
    public void testAbstractParent() {
        Invocation.Builder builder = client.target(this.generateURL("/inheritance-abstract-parent-test")).request();
        builder.header("Accept", (Object)"text/plain");
        Response response = builder.get();
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        Assertions.assertEquals((Object)response.readEntity(String.class), (Object)"works");
    }

    static {
        testExtension = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

            @Override
            public JavaArchive get() {
                JavaArchive war = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
                war.addClass(InheritanceParentResource.class);
                war.addClass(InheritanceAbstractParentResource.class);
                war.addClass(InheritanceAbstractParentImplResource.class);
                war.addClasses(new Class[]{PortProviderUtil.class, InheritanceParentResourceImpl.class});
                return war;
            }
        });
    }
}

