/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.resource.basic;

import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.MatchedResource;
import io.quarkus.resteasy.reactive.server.test.simple.PortProviderUtil;
import io.quarkus.test.QuarkusUnitTest;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.util.function.Supplier;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

@DisplayName(value="Matched Resource Test")
public class MatchedResourceTest {
    static Client client;
    @RegisterExtension
    static QuarkusUnitTest testExtension;

    @BeforeAll
    public static void init() {
        client = ClientBuilder.newClient();
    }

    @AfterAll
    public static void close() {
        client.close();
    }

    private static String generateURL(String path) {
        return PortProviderUtil.generateURL(path, MatchedResourceTest.class.getSimpleName());
    }

    @Test
    @DisplayName(value="Test Empty")
    public void testEmpty() throws Exception {
        WebTarget base = client.target(MatchedResourceTest.generateURL("/start"));
        Response response = base.request().post(Entity.text((Object)""));
        Assertions.assertEquals((int)response.getStatus(), (int)Response.Status.OK.getStatusCode());
        String rtn = (String)response.readEntity(String.class);
        Assertions.assertEquals((Object)"started", (Object)rtn);
        response.close();
        base = client.target(MatchedResourceTest.generateURL("/start"));
        response = base.request().post(Entity.entity((Object)"<xml/>", (String)"application/xml"));
        Assertions.assertEquals((int)response.getStatus(), (int)Response.Status.OK.getStatusCode());
        rtn = (String)response.readEntity(String.class);
        Assertions.assertEquals((Object)"<xml/>", (Object)rtn, (String)"Wrong response content");
        response.close();
    }

    @Test
    @DisplayName(value="Test Match")
    public void testMatch() throws Exception {
        WebTarget base = client.target(MatchedResourceTest.generateURL("/match"));
        Response response = base.request().header("Accept", (Object)"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8").get();
        Assertions.assertEquals((Object)"text/html;charset=UTF-8", (Object)response.getHeaders().getFirst((Object)"Content-Type"));
        String res = (String)response.readEntity(String.class);
        Assertions.assertEquals((Object)"*/*", (Object)res, (String)"Wrong response content");
        response.close();
    }

    public void generalPostTest(String uri, String value) {
        WebTarget base = client.target(uri);
        Response response = base.request().get();
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        Assertions.assertEquals((Object)response.readEntity(String.class), (Object)value, (String)"Wrong response content");
    }

    @Test
    @DisplayName(value="Test Post")
    public void testPost() {
        this.generalPostTest(MatchedResourceTest.generateURL("/test2/foo.xml.en"), "complex2");
        this.generalPostTest(MatchedResourceTest.generateURL("/test1/foo.xml.en"), "complex");
    }

    static {
        testExtension = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

            @Override
            public JavaArchive get() {
                JavaArchive war = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
                war.addClasses(new Class[]{MatchedResource.class, PortProviderUtil.class});
                return war;
            }
        });
    }
}

