/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.resource.basic;

import io.quarkus.resteasy.reactive.server.test.simple.PortProviderUtil;
import io.quarkus.test.QuarkusUnitTest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.function.Supplier;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

@DisplayName(value="Media Type Negotiation Client Quality Test")
public class MediaTypeNegotiationClientQualityTest {
    private static Client client;
    private static final String DEP = "MediaTypeNegotiationClientQualityTest";
    @RegisterExtension
    static QuarkusUnitTest testExtension;

    @BeforeAll
    public static void setup() {
        client = ClientBuilder.newClient();
    }

    @AfterAll
    public static void cleanup() {
        client.close();
    }

    private String generateURL() {
        return PortProviderUtil.generateBaseUrl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DisplayName(value="Test Client Quality")
    public void testClientQuality() throws Exception {
        Invocation.Builder request = client.target(this.generateURL()).path("echo").request(new String[]{"application/x;q=0.7", "application/y;q=0.9"});
        try (Response response = request.get();){
            Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
            MediaType mediaType = response.getMediaType();
            Assertions.assertEquals((Object)mediaType.getType(), (Object)"application");
            Assertions.assertEquals((Object)mediaType.getSubtype(), (Object)"y");
        }
    }

    static {
        testExtension = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

            @Override
            public JavaArchive get() {
                JavaArchive war = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
                war.addClasses(new Class[]{PortProviderUtil.class, CustomMessageBodyWriter1.class, Resource.class});
                return war;
            }
        });
    }

    @Path(value="/echo")
    public static class Resource {
        @GET
        public Object nothing() {
            return new Object();
        }
    }

    @Produces(value={"application/x;qs=0.9", "application/y;qs=0.7"})
    @DisplayName(value="Custom Message Body Writer 1")
    @Provider
    public static class CustomMessageBodyWriter1
    implements MessageBodyWriter<Object> {
        public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return true;
        }

        public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return -1L;
        }

        public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        }
    }
}

