/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.resource.basic;

import io.quarkus.resteasy.reactive.server.test.simple.PortProviderUtil;
import io.quarkus.test.QuarkusUnitTest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.function.Supplier;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

@DisplayName(value="Media Type Negotiation Server Quality Test")
public class MediaTypeNegotiationServerQualityTest {
    private static Client client;
    @RegisterExtension
    static QuarkusUnitTest testExtension;

    @BeforeAll
    public static void setup() {
        client = ClientBuilder.newClient();
    }

    @AfterAll
    public static void cleanup() {
        client.close();
    }

    private String generateURL() {
        return PortProviderUtil.generateBaseUrl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DisplayName(value="Test Server Quality")
    public void testServerQuality() throws Exception {
        Invocation.Builder request = client.target(this.generateURL()).path("foo/echo").request(new String[]{"application/x;", "text/y"});
        try (Response response = request.get();){
            Assertions.assertEquals((int)Response.Status.NOT_FOUND.getStatusCode(), (int)response.getStatus());
            MediaType mediaType = response.getMediaType();
            Assertions.assertEquals((Object)"text", (Object)mediaType.getType());
            Assertions.assertEquals((Object)"y", (Object)mediaType.getSubtype());
        }
    }

    static {
        testExtension = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

            @Override
            public JavaArchive get() {
                JavaArchive war = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
                war.addClasses(new Class[]{PortProviderUtil.class, CustomMessageBodyWriter.class, FakeResource.class, NotFoundExceptionMapper.class});
                return war;
            }
        });
    }

    @Path(value="/foo")
    public static class FakeResource {
        @GET
        @Path(value="/fake")
        public String fake() {
            return "";
        }
    }

    @DisplayName(value="Not Found Exception Mapper")
    @Provider
    public static class NotFoundExceptionMapper
    implements ExceptionMapper<NotFoundException> {
        public Response toResponse(NotFoundException notFoundException) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity(new Object()).build();
        }
    }

    @Produces(value={"application/*;qs=0.7", "text/*;qs=0.9"})
    @DisplayName(value="Custom Message Body Writer")
    @Provider
    public static class CustomMessageBodyWriter
    implements MessageBodyWriter<Object> {
        public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return true;
        }

        public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return -1L;
        }

        public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        }
    }
}

