/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.resource.basic;

import io.quarkus.resteasy.reactive.server.test.simple.PortProviderUtil;
import io.quarkus.test.QuarkusUnitTest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.client.ClientBuilder;
import java.util.function.Supplier;
import org.jboss.resteasy.reactive.client.impl.ClientImpl;
import org.jboss.resteasy.reactive.client.impl.WebTargetImpl;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

@DisplayName(value="Multiple Accept Header Test")
public class MultipleAcceptHeaderTest {
    protected static String APPLICATION_JSON = "Content-Type: application/json";
    protected static String APPLICATION_XML = "Content-Type: application/xml";
    private TestInterfaceClient service;
    private ClientImpl client;
    @RegisterExtension
    static QuarkusUnitTest testExtension = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            JavaArchive war = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
            war.addClasses(new Class[]{TestResourceServer.class, PortProviderUtil.class});
            return war;
        }
    });

    private String generateBaseUrl() {
        return PortProviderUtil.generateBaseUrl();
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.client = (ClientImpl)ClientBuilder.newClient();
        WebTargetImpl target = (WebTargetImpl)this.client.target(this.generateBaseUrl());
        this.service = (TestInterfaceClient)target.proxy(TestInterfaceClient.class);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.client.close();
        this.client = null;
    }

    @Test
    @DisplayName(value="Test Single Accept Header")
    public void testSingleAcceptHeader() throws Exception {
        String result = this.service.getJson();
        Assertions.assertEquals((Object)APPLICATION_JSON, (Object)result);
    }

    @Test
    @DisplayName(value="Test Single Accept Header 2")
    public void testSingleAcceptHeader2() throws Exception {
        String result = this.service.getXml();
        Assertions.assertEquals((Object)APPLICATION_XML, (Object)result);
    }

    @Test
    @DisplayName(value="Test Multiple Accept Header")
    public void testMultipleAcceptHeader() throws Exception {
        String result = this.service.getXmlMultiple();
        Assertions.assertEquals((Object)APPLICATION_XML, (Object)result);
    }

    @Test
    @DisplayName(value="Test Multiple Accept Header Second Header")
    public void testMultipleAcceptHeaderSecondHeader() throws Exception {
        String result = this.service.getXmlPlainMultiple();
        Assertions.assertEquals((Object)APPLICATION_XML, (Object)result);
    }

    @Path(value="test")
    @DisplayName(value="Test Interface Client")
    static interface TestInterfaceClient {
        @GET
        @Path(value="accept")
        @Produces(value={"application/json"})
        public String getJson();

        @GET
        @Path(value="accept")
        @Produces(value={"application/xml"})
        public String getXml();

        @GET
        @Path(value="accept")
        @Produces(value={"application/wrong1", "application/wrong2", "application/xml"})
        public String getXmlMultiple();

        @GET
        @Path(value="accept")
        @Produces(value={"application/wrong1", "text/plain"})
        public String getXmlPlainMultiple();
    }

    @Path(value="/test")
    @DisplayName(value="Test Resource Server")
    public static class TestResourceServer {
        @GET
        @Path(value="accept")
        @Produces(value={"application/json"})
        public String acceptJson() {
            return APPLICATION_JSON;
        }

        @GET
        @Path(value="accept")
        @Produces(value={"application/xml, text/plain"})
        public String acceptXml() {
            return APPLICATION_XML;
        }
    }
}

