/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.resource.basic;

import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.function.Supplier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.resteasy.reactive.RestPath;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class MultipleResourceImplementInterfaceTest {
    @RegisterExtension
    static QuarkusUnitTest testExtension = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            JavaArchive war = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
            war.addClass(HelloResource.class);
            war.addClass(Hello2Resource.class);
            war.addClass(Shared.class);
            return war;
        }
    });

    @Test
    public void hello() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/hello", new Object[0])).then()).statusCode(200)).body(CoreMatchers.is((Object)"hello"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/hello/shared/1", new Object[0])).then()).statusCode(200)).body(CoreMatchers.is((Object)"1"), new Matcher[0]);
    }

    @Test
    public void hello2() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/hello2", new Object[0])).then()).statusCode(200)).body(CoreMatchers.is((Object)"hello2"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/hello2/shared/h2", new Object[0])).then()).statusCode(200)).body(CoreMatchers.is((Object)"h2"), new Matcher[0]);
    }

    public static interface Shared {
        @GET
        @Path(value="/shared/{id}")
        default public String version(@RestPath String id) {
            return id;
        }
    }

    @Path(value="/hello2")
    public static class Hello2Resource
    implements Shared {
        @GET
        public String hello() {
            return "hello2";
        }
    }

    @Path(value="/hello")
    public static class HelloResource
    implements Shared {
        @GET
        public String hello() {
            return "hello";
        }
    }
}

