/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.resource.basic;

import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.GetAbsolutePathResource;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.UriInfoEncodedQueryResource;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.UriInfoEncodedTemplateResource;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.UriInfoEscapedMatrParamResource;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.UriInfoQueryParamsResource;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.UriInfoSimpleResource;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.UriInfoSimpleSingletonResource;
import io.quarkus.resteasy.reactive.server.test.simple.PortProviderUtil;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

@DisplayName(value="Uri Info Test")
public class UriInfoTest {
    protected final Logger logger = Logger.getLogger(UriInfoTest.class);
    private static Client client;
    @RegisterExtension
    static QuarkusUnitTest quarkusUnitTest;

    @BeforeAll
    public static void before() throws Exception {
        client = ClientBuilder.newClient();
    }

    @AfterAll
    public static void after() throws Exception {
        client.close();
        client = null;
    }

    @Test
    @DisplayName(value="Test Uri Info")
    public void testUriInfo() throws Exception {
        UriInfoTest.basicTest("/simple", UriInfoSimpleResource.class.getSimpleName());
        UriInfoTest.basicTest("/simple/fromField", UriInfoSimpleResource.class.getSimpleName());
        ((ValidatableResponse)RestAssured.get((String)("/" + UriInfoSimpleResource.class.getSimpleName() + "/uri?foo=bar"), (Object[])new Object[0]).then()).body(Matchers.endsWith((String)"/uri?foo=bar"), new Matcher[0]);
    }

    @Test
    @Disabled
    @DisplayName(value="Test Uri Info With Singleton")
    public void testUriInfoWithSingleton() throws Exception {
        UriInfoTest.basicTest("/simple/fromField", UriInfoSimpleSingletonResource.class.getSimpleName());
    }

    @Test
    @Disabled
    @DisplayName(value="Test Escaped Matr Param")
    public void testEscapedMatrParam() throws Exception {
        UriInfoTest.basicTest("/queryEscapedMatrParam;a=a%3Bb;b=x%2Fy;c=m%5Cn;d=k%3Dl", UriInfoEscapedMatrParamResource.class.getSimpleName());
    }

    @Test
    @Disabled
    @DisplayName(value="Test Encoded Template Params")
    public void testEncodedTemplateParams() throws Exception {
        UriInfoTest.basicTest("/a%20b/x%20y", UriInfoEncodedTemplateResource.class.getSimpleName());
    }

    @Test
    @Disabled
    @DisplayName(value="Test Encoded Query Params")
    public void testEncodedQueryParams() throws Exception {
        UriInfoTest.basicTest("/query?a=a%20b", UriInfoEncodedQueryResource.class.getSimpleName());
    }

    @Test
    @Disabled
    @DisplayName(value="Test Relativize")
    public void testRelativize() throws Exception {
        String uri = PortProviderUtil.generateURL("/");
        WebTarget target = client.target(uri);
        String result = (String)target.path("a/b/c").queryParam("to", new Object[]{"a/d/e"}).request().get(String.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"../../d/e", (Object)result);
        result = (String)target.path("a/b/c").queryParam("to", new Object[]{UriBuilder.fromUri((String)uri).path("a/d/e").build(new Object[0]).toString()}).request().get(String.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)result, (Object)"../../d/e");
        result = (String)target.path("a/b/c").queryParam("to", new Object[]{"http://foobar/a/d/e"}).request().get(String.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)result, (Object)"http://foobar/a/d/e");
    }

    private static void basicTest(String path, String testName) throws Exception {
        try (Response response = client.target(PortProviderUtil.generateURL("/" + testName + path)).request().get();){
            org.junit.jupiter.api.Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        }
    }

    @Test
    @DisplayName(value="Test Query Params Mutability")
    public void testQueryParamsMutability() throws Exception {
        UriInfoTest.basicTest("/queryParams?a=a,b", "UriInfoQueryParamsResource");
    }

    @Test
    @DisplayName(value="Test Get Absolute Path")
    public void testGetAbsolutePath() throws Exception {
        this.doTestGetAbsolutePath("/absolutePath", "unset");
        this.doTestGetAbsolutePath("/absolutePath?dummy=1234", "1234");
        this.doTestGetAbsolutePath("/absolutePath?foo=bar&dummy=1234", "1234");
    }

    private void doTestGetAbsolutePath(String path, String expectedDummyHeader) {
        String absolutePathHeader = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)path, (Object[])new Object[0]).then()).statusCode(200)).header("dummy", expectedDummyHeader)).extract().header("absolutePath");
        Assertions.assertThat((String)absolutePathHeader).endsWith((CharSequence)"/absolutePath");
    }

    static {
        quarkusUnitTest = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

            @Override
            public JavaArchive get() {
                JavaArchive war = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
                war.addClass(PortProviderUtil.class);
                war.addClasses(new Class[]{UriInfoSimpleResource.class, UriInfoEncodedQueryResource.class, UriInfoQueryParamsResource.class, UriInfoSimpleSingletonResource.class, UriInfoEncodedTemplateResource.class, UriInfoEscapedMatrParamResource.class, UriInfoEncodedTemplateResource.class, GetAbsolutePathResource.class});
                return war;
            }
        });
    }
}

