/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.resource.basic.resource;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import java.util.List;
import java.util.Locale;
import org.junit.jupiter.api.Assertions;

@Path(value="/extension")
public class ExtensionResource {
    @GET
    @Produces(value={"*/*"})
    public String getDefault() {
        return "default";
    }

    @GET
    @Produces(value={"application/xml"})
    public String getXml(@Context HttpHeaders headers) {
        List languages = headers.getAcceptableLanguages();
        List mediaTypes = headers.getAcceptableMediaTypes();
        return "xml";
    }

    @GET
    @Produces(value={"text/html"})
    public String getXmlTwo(@Context HttpHeaders headers) {
        List languages = headers.getAcceptableLanguages();
        Assertions.assertEquals((int)1, (int)languages.size(), (String)"Wrong number of accepted languages");
        Assertions.assertEquals((Object)new Locale("en", "us"), languages.get(0), (String)"Wrong accepted language");
        Assertions.assertEquals((Object)MediaType.valueOf((String)"text/html"), headers.getAcceptableMediaTypes().get(0), (String)"Wrong accepted language");
        return "html";
    }

    @GET
    @Path(value="/stuff.old")
    @Produces(value={"text/plain"})
    public String getJson(@Context HttpHeaders headers) {
        List languages = headers.getAcceptableLanguages();
        Assertions.assertEquals((int)1, (int)languages.size(), (String)"Wrong number of accepted languages");
        Assertions.assertEquals((Object)new Locale("en", "us"), languages.get(0), (String)"Wrong accepted language");
        Assertions.assertEquals((Object)MediaType.valueOf((String)"text/plain"), headers.getAcceptableMediaTypes().get(0), (String)"Wrong accepted language");
        return "plain";
    }
}

