/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.resource.basic.resource;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;

@Path(value="/HeadersTest")
public class HttpHeadersResource {
    private static Logger logger = Logger.getLogger(HttpHeadersResource.class);

    @GET
    @Path(value="/headers")
    public String headersGet(@Context HttpHeaders hs) {
        StringBuffer sb = new StringBuffer();
        List<String> myHeaders = Arrays.asList("Accept", "Content-Type");
        try {
            MultivaluedMap rqhdrs = hs.getRequestHeaders();
            Set keys = rqhdrs.keySet();
            sb.append("getRequestHeaders= ");
            for (String header : myHeaders) {
                if (!keys.contains(header)) continue;
                sb.append("Found " + header + ": " + hs.getRequestHeader(header) + "; ");
            }
        }
        catch (Throwable ex) {
            sb.append("Unexpected exception thrown in getRequestHeaders: " + ex.getMessage());
            StringWriter errors = new StringWriter();
            ex.printStackTrace(new PrintWriter(errors));
            logger.error((Object)errors.toString());
        }
        return sb.toString();
    }

    @GET
    @Path(value="/acl")
    public String aclGet(@Context HttpHeaders hs) {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append("Accept-Language");
            List acl = hs.getAcceptableLanguages();
            sb.append("getLanguage= ");
            for (Locale tmp : acl) {
                sb.append(tmp.toString() + "; ");
            }
        }
        catch (Throwable ex) {
            sb.append("Unexpected exception thrown in getAcceptableLanguages: " + ex.getMessage());
            StringWriter errors = new StringWriter();
            ex.printStackTrace(new PrintWriter(errors));
            logger.error((Object)errors.toString());
        }
        return sb.toString();
    }

    @GET
    @Path(value="/amt")
    public String amtGet(@Context HttpHeaders hs) {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append("getAcceptableMediaTypes");
            List acmts = hs.getAcceptableMediaTypes();
            for (MediaType mt : acmts) {
                sb.append(mt.getType());
                sb.append("/");
                sb.append(mt.getSubtype());
            }
        }
        catch (Throwable ex) {
            sb.append("Unexpected exception thrown: " + ex.getMessage());
            StringWriter errors = new StringWriter();
            ex.printStackTrace(new PrintWriter(errors));
            logger.error((Object)errors.toString());
        }
        return sb.toString();
    }

    @GET
    @Path(value="/mt")
    public String mtGet(@Context HttpHeaders hs) {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append("getMediaType");
            MediaType mt = hs.getMediaType();
            if (mt != null) {
                sb.append(mt.getType());
                sb.append("/");
                sb.append(mt.getSubtype());
                sb.append(" ");
                Map pmap = mt.getParameters();
                sb.append("MediaType size=" + pmap.size());
                for (Map.Entry entry : pmap.entrySet()) {
                    sb.append("Key " + (String)entry.getKey() + "; Value " + (String)entry.getValue());
                }
                sb.append(mt.toString());
                sb.append("MediaType= " + mt.toString() + "; ");
            } else {
                sb.append("MediaType= null; ");
            }
        }
        catch (Throwable ex) {
            sb.append("Unexpected exception thrown: " + ex.getMessage());
            StringWriter errors = new StringWriter();
            ex.printStackTrace(new PrintWriter(errors));
            logger.error((Object)errors.toString());
        }
        return sb.toString();
    }

    @GET
    @Path(value="/cookie")
    public String cookieGet(@Context HttpHeaders hs) {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append("getCookies= ");
            Map cookies = hs.getCookies();
            sb.append("Cookie Size=" + cookies.size());
            for (Map.Entry tmp : cookies.entrySet()) {
                sb.append((String)tmp.getKey() + ": " + tmp.getValue() + "; ");
                Cookie c = (Cookie)cookies.get("name1");
                sb.append("Cookie Name=" + c.getName());
                sb.append("Cookie Value=" + c.getValue());
                sb.append("Cookie Path=" + c.getPath());
                sb.append("Cookie Domain=" + c.getDomain());
                sb.append("Cookie Version=" + c.getVersion());
            }
        }
        catch (Throwable ex) {
            sb.append("Unexpected exception thrown: " + ex.getMessage());
            StringWriter errors = new StringWriter();
            ex.printStackTrace(new PrintWriter(errors));
            logger.error((Object)errors.toString());
        }
        return sb.toString();
    }

    @PUT
    public String headersPlainPut(@Context HttpHeaders hs) {
        StringBuffer sb = new StringBuffer();
        sb.append("Content-Language");
        sb.append(hs.getLanguage());
        return sb.toString();
    }
}

