/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.resource.basic.resource;

import io.quarkus.resteasy.reactive.server.test.simple.PortProviderUtil;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Assertions;

@Path(value="/UriInfoSimpleResource")
public class UriInfoSimpleResource {
    private static Logger LOG = Logger.getLogger(UriInfoSimpleResource.class);
    @Context
    UriInfo myInfo;

    @Path(value="/simple")
    @GET
    public String get(@Context UriInfo info, @QueryParam(value="abs") String abs) {
        LOG.debug((Object)("abs query: " + abs));
        URI base = null;
        base = abs == null ? PortProviderUtil.createURI("/") : PortProviderUtil.createURI("/" + abs + "/");
        LOG.debug((Object)("BASE URI: " + info.getBaseUri()));
        LOG.debug((Object)("Request URI: " + info.getRequestUri()));
        LOG.debug((Object)("Absolute URI: " + info.getAbsolutePath()));
        Assertions.assertEquals((Object)base.getPath(), (Object)info.getBaseUri().getPath());
        Assertions.assertEquals((Object)"/UriInfoSimpleResource/simple", (Object)info.getPath());
        return "CONTENT";
    }

    @Path(value="/uri")
    @GET
    public String get(@Context UriInfo info) {
        return info.getRequestUri().toASCIIString();
    }

    @Path(value="/simple/fromField")
    @GET
    public String getField(@QueryParam(value="abs") String abs) {
        LOG.debug((Object)("abs query: " + abs));
        URI base = null;
        base = abs == null ? PortProviderUtil.createURI("/") : PortProviderUtil.createURI("/" + abs + "/");
        LOG.debug((Object)("BASE URI: " + this.myInfo.getBaseUri()));
        LOG.debug((Object)("Request URI: " + this.myInfo.getRequestUri()));
        Assertions.assertEquals((Object)base.getPath(), (Object)this.myInfo.getBaseUri().getPath());
        Assertions.assertEquals((Object)"/UriInfoSimpleResource/simple/fromField", (Object)this.myInfo.getPath());
        return "CONTENT";
    }
}

