/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.response;

import io.quarkus.resteasy.reactive.server.test.response.UnknownCheeseException1;
import io.quarkus.resteasy.reactive.server.test.response.UnknownCheeseException2;
import io.smallrye.mutiny.Uni;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.Variant;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;
import org.jboss.resteasy.reactive.RestResponse;
import org.jboss.resteasy.reactive.server.ServerExceptionMapper;
import org.jboss.resteasy.reactive.server.ServerRequestFilter;

@Path(value="")
public class RestResponseResource {
    @GET
    @Path(value="rest-response")
    public RestResponse<String> getString() {
        return RestResponse.ok((Object)"Hello");
    }

    @GET
    @Path(value="rest-response-full")
    public RestResponse<String> getResponse() throws URISyntaxException {
        CacheControl cc = new CacheControl();
        cc.setMaxAge(42);
        cc.setPrivate(true);
        return RestResponse.ResponseBuilder.ok((Object)"Hello").allow(new String[]{"FOO", "BAR"}).cacheControl(cc).contentLocation(new URI("http://example.com/content")).cookie(new NewCookie[]{new NewCookie("Flavour", "Pralin\u00e9")}).encoding("Stef-Encoding").expires(Date.from(Instant.parse("2021-01-01T00:00:00Z"))).header("X-Stef", (Object)"FroMage").language(Locale.FRENCH).lastModified(Date.from(Instant.parse("2021-01-02T00:00:00Z"))).link("http://example.com/link", "stef").location(new URI("http://example.com/location")).tag("yourit").type("text/stef").variants(Variant.languages((Locale[])new Locale[]{Locale.ENGLISH, Locale.GERMAN}).build()).build();
    }

    @GET
    @Path(value="response-uni")
    public Response getResponseUniString() {
        return Response.ok((Object)Uni.createFrom().item((Object)"Hello")).build();
    }

    @GET
    @Path(value="rest-response-uni")
    public RestResponse<Uni<String>> getUniString() {
        return RestResponse.ok((Object)Uni.createFrom().item((Object)"Hello"));
    }

    @GET
    @Path(value="rest-response-exception")
    public String getRestResponseException() {
        throw new UnknownCheeseException1("Cheddar");
    }

    @GET
    @Path(value="uni-rest-response-exception")
    public String getUniRestResponseException() {
        throw new UnknownCheeseException2("Cheddar");
    }

    @ServerExceptionMapper
    public RestResponse<String> mapException(UnknownCheeseException1 x) {
        return RestResponse.status((Response.StatusType)Response.Status.NOT_FOUND, (Object)("Unknown cheese: " + x.name));
    }

    @ServerExceptionMapper
    public Uni<RestResponse<String>> mapExceptionAsync(UnknownCheeseException2 x) {
        return Uni.createFrom().item((Object)RestResponse.status((Response.StatusType)Response.Status.NOT_FOUND, (Object)("Unknown cheese: " + x.name)));
    }

    @ServerRequestFilter(preMatching=true)
    public RestResponse<String> restResponseRequestFilter(ContainerRequestContext ctx) {
        if (ctx.getUriInfo().getPath().equals("/rest-response-request-filter")) {
            return RestResponse.ok((Object)"RestResponse request filter");
        }
        return null;
    }

    @ServerRequestFilter(preMatching=true)
    public Optional<RestResponse<String>> optionalRestResponseRequestFilter(ContainerRequestContext ctx) {
        if (ctx.getUriInfo().getPath().equals("/optional-rest-response-request-filter")) {
            return Optional.of(RestResponse.ok((Object)"Optional<RestResponse> request filter"));
        }
        return Optional.empty();
    }

    @ServerRequestFilter(preMatching=true)
    public Uni<RestResponse<String>> uniRestResponseRequestFilter(ContainerRequestContext ctx) {
        if (ctx.getUriInfo().getPath().equals("/uni-rest-response-request-filter")) {
            return Uni.createFrom().item((Object)RestResponse.ok((Object)"Uni<RestResponse> request filter"));
        }
        return null;
    }
}

