/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.resteasy.async.filters;

import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;

@Path(value="/")
public class AsyncRequestFilterResource {
    private static final Logger LOG = Logger.getLogger(AsyncRequestFilterResource.class);

    @GET
    public Response threeSyncRequestFilters(@Context ServerRequestContext ctx, @HeaderParam(value="Filter1") @DefaultValue(value="") String filter1, @HeaderParam(value="Filter2") @DefaultValue(value="") String filter2, @HeaderParam(value="Filter3") @DefaultValue(value="") String filter3, @HeaderParam(value="PreMatchFilter1") @DefaultValue(value="") String preMatchFilter1, @HeaderParam(value="PreMatchFilter2") @DefaultValue(value="") String preMatchFilter2, @HeaderParam(value="PreMatchFilter3") @DefaultValue(value="") String preMatchFilter3) {
        return Response.ok((Object)"resource").build();
    }

    @Path(value="non-response")
    @GET
    public String threeSyncRequestFiltersNonResponse(@Context ServerRequestContext ctx, @HeaderParam(value="Filter1") @DefaultValue(value="") String filter1, @HeaderParam(value="Filter2") @DefaultValue(value="") String filter2, @HeaderParam(value="Filter3") @DefaultValue(value="") String filter3, @HeaderParam(value="PreMatchFilter1") @DefaultValue(value="") String preMatchFilter1, @HeaderParam(value="PreMatchFilter2") @DefaultValue(value="") String preMatchFilter2, @HeaderParam(value="PreMatchFilter3") @DefaultValue(value="") String preMatchFilter3) {
        return "resource";
    }

    @Path(value="async")
    @GET
    public CompletionStage<Response> async() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        CompletableFuture<Response> resp = new CompletableFuture<Response>();
        executor.submit(() -> {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                LOG.error((Object)"Error:", (Throwable)e);
            }
            resp.complete(Response.ok((Object)"resource").build());
        });
        return resp;
    }

    @Path(value="callback")
    @GET
    public String callback() {
        return "hello";
    }

    @Path(value="callback-async")
    @GET
    public CompletionStage<String> callbackAsync() {
        return CompletableFuture.completedFuture("hello");
    }

    private boolean isAsync(String filter) {
        return filter.equals("async-pass") || filter.equals("async-fail");
    }
}

