/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.security;

import io.quarkus.resteasy.reactive.server.test.security.AnnotationBasedAuthMechanismSelectionTest;
import io.restassured.RestAssured;
import io.restassured.filter.Filter;
import io.restassured.filter.cookie.CookieFilter;
import io.restassured.matcher.RestAssuredMatchers;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class AuthMechRequest {
    final String path;
    final String expectedHeaderKey;
    String expectedBody;
    Matcher<Object> expectedHeaderVal;
    int expectedStatus;
    boolean authRequired;
    Supplier<RequestSpecification> requestSpecification;
    Supplier<RequestSpecification> unauthorizedRequestSpec;
    Supplier<RequestSpecification> unauthenticatedRequestSpec = RestAssured::given;
    Supplier<RequestSpecification> requestUsingOtherAuthMech;

    public AuthMechRequest(String path) {
        this.path = path;
        this.expectedHeaderKey = AnnotationBasedAuthMechanismSelectionTest.CustomBasicAuthMechanism.CUSTOM_AUTH_HEADER_KEY;
        this.expectedBody = path.substring(path.lastIndexOf(47) + 1);
        this.expectedStatus = 200;
        this.authRequired = true;
    }

    AuthMechRequest basic() {
        this.requestSpecification = AuthMechRequest::requestWithBasicAuth;
        this.unauthorizedRequestSpec = AuthMechRequest::requestWithBasicAuthUser;
        this.requestUsingOtherAuthMech = () -> AuthMechRequest.requestWithFormAuth("admin");
        this.expectedHeaderVal = Matchers.nullValue();
        return this;
    }

    AuthMechRequest custom() {
        this.basic();
        this.expectedHeaderVal = Matchers.notNullValue();
        return this;
    }

    AuthMechRequest noRbacAnnotation() {
        this.authRequest();
        this.expectedBody = "admin";
        return this;
    }

    AuthMechRequest defaultAuthMech() {
        this.expectedHeaderVal = Matchers.anything();
        this.requestUsingOtherAuthMech = null;
        return this;
    }

    AuthMechRequest denyPolicy() {
        this.expectedStatus = 403;
        this.expectedBody = "";
        return this;
    }

    AuthMechRequest authRequest() {
        this.unauthorizedRequestSpec = null;
        return this;
    }

    AuthMechRequest pathAnnotationDeclaredOnInterface() {
        this.authRequired = false;
        return this;
    }

    AuthMechRequest form() {
        this.requestSpecification = () -> AuthMechRequest.requestWithFormAuth("admin");
        this.unauthorizedRequestSpec = () -> AuthMechRequest.requestWithFormAuth("user");
        this.requestUsingOtherAuthMech = AuthMechRequest::requestWithBasicAuth;
        this.expectedHeaderVal = Matchers.nullValue();
        return this;
    }

    static RequestSpecification requestWithBasicAuth() {
        return RestAssured.given().auth().preemptive().basic("admin", "admin");
    }

    static RequestSpecification requestWithFormAuth(String user) {
        CookieFilter cookies = new CookieFilter();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().filter((Filter)cookies).when().formParam("j_username", new Object[]{user}).formParam("j_password", new Object[]{user}).post("/j_security_check", new Object[0])).then()).assertThat()).statusCode(200)).cookie("quarkus-credential", RestAssuredMatchers.detailedCookie().value(Matchers.notNullValue()).secured(false));
        return RestAssured.given().filter((Filter)cookies);
    }

    static RequestSpecification requestWithBasicAuthUser() {
        return RestAssured.given().auth().preemptive().basic("user", "user");
    }
}

