/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.security;

import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.identity.request.BaseAuthenticationRequest;
import io.quarkus.test.QuarkusUnitTest;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.restassured.RestAssured;
import io.restassured.http.Header;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.smallrye.mutiny.Uni;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.Set;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class AuthenticationFailedExceptionHeaderTest {
    private static final String APP_PROPS = "quarkus.http.auth.permission.default.paths=/*\nquarkus.http.auth.permission.default.policy=authenticated";
    @RegisterExtension
    static QuarkusUnitTest runner = new QuarkusUnitTest().withApplicationRoot(jar -> jar.addAsResource((Asset)new StringAsset(APP_PROPS), "application.properties"));

    @Test
    public void testHeaders() {
        Response response = (Response)RestAssured.given().redirects().follow(false).when().get("/secured-route", new Object[0]);
        ((ValidatableResponse)response.then()).statusCode(302);
        Assertions.assertEquals((long)1L, (long)response.headers().asList().stream().map(Header::getName).map(String::toLowerCase).filter(HttpHeaders.LOCATION.toString()::equals).count());
    }

    @ApplicationScoped
    public static class BasicIdentityProvider
    implements IdentityProvider<BaseAuthenticationRequest> {
        public Class<BaseAuthenticationRequest> getRequestType() {
            return BaseAuthenticationRequest.class;
        }

        public Uni<SecurityIdentity> authenticate(BaseAuthenticationRequest simpleAuthenticationRequest, AuthenticationRequestContext authenticationRequestContext) {
            return Uni.createFrom().nothing();
        }
    }

    @ApplicationScoped
    public static class FailingAuthenticator
    implements HttpAuthenticationMechanism {
        public Uni<SecurityIdentity> authenticate(RoutingContext context, IdentityProviderManager identityProviderManager) {
            return Uni.createFrom().failure((Throwable)new AuthenticationFailedException());
        }

        public Set<Class<? extends AuthenticationRequest>> getCredentialTypes() {
            return Set.of(BaseAuthenticationRequest.class);
        }

        public Uni<ChallengeData> getChallenge(RoutingContext context) {
            return Uni.createFrom().item((Object)new ChallengeData(302, HttpHeaders.LOCATION, "http://localhost:8080/"));
        }
    }
}

