/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.security;

import io.quarkus.builder.BuildContext;
import io.quarkus.builder.BuildStep;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.resteasy.reactive.server.spi.AnnotationsTransformerBuildItem;
import io.quarkus.resteasy.reactive.server.test.security.HelloResource;
import io.quarkus.resteasy.reactive.server.test.security.PermitAllResource;
import io.quarkus.resteasy.reactive.server.test.security.UnsecuredParentResource;
import io.quarkus.resteasy.reactive.server.test.security.UnsecuredResource;
import io.quarkus.resteasy.reactive.server.test.security.UnsecuredResourceInterface;
import io.quarkus.resteasy.reactive.server.test.security.UnsecuredSubResource;
import io.quarkus.security.test.utils.TestIdentityController;
import io.quarkus.security.test.utils.TestIdentityProvider;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.lang.reflect.Modifier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.resteasy.reactive.common.processor.transformation.AnnotationsTransformer;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class DenyAllJaxRsTest {
    @RegisterExtension
    static QuarkusUnitTest runner = new QuarkusUnitTest().withApplicationRoot(jar -> ((JavaArchive)jar.addClasses(new Class[]{PermitAllResource.class, UnsecuredResource.class, TestIdentityProvider.class, UnsecuredResourceInterface.class, TestIdentityController.class, SpecialResource.class, UnsecuredSubResource.class, HelloResource.class, UnsecuredParentResource.class})).addAsResource((Asset)new StringAsset("quarkus.security.jaxrs.deny-unannotated-endpoints = true\n"), "application.properties")).addBuildChainCustomizer(builder -> builder.addBuildStep(new BuildStep(){

        public void execute(BuildContext context) {
            context.produce((BuildItem)new AnnotationsTransformerBuildItem(AnnotationsTransformer.builder().appliesTo(AnnotationTarget.Kind.METHOD).transform(transformerContext -> {
                MethodInfo methodInfo = transformerContext.getTarget().asMethod();
                ClassInfo declaringClass = methodInfo.declaringClass();
                if (declaringClass.name().toString().equals(SpecialResource.class.getName()) && !methodInfo.isConstructor() && !Modifier.isStatic(methodInfo.flags())) {
                    if (methodInfo.declaredAnnotation(GET.class.getName()) == null) {
                        transformerContext.transform().add(GET.class, new AnnotationValue[0]).done();
                    }
                    if (methodInfo.declaredAnnotation(Path.class.getName()) == null) {
                        transformerContext.transform().add(Path.class, new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)methodInfo.name())}).done();
                    }
                }
            })));
        }
    }).produces(AnnotationsTransformerBuildItem.class).build());

    @BeforeAll
    public static void setupUsers() {
        TestIdentityController.resetRoles().add("admin", "admin", new String[]{"admin"}).add("user", "user", new String[]{"user"});
    }

    @Test
    public void shouldDenyUnannotated() {
        String path = "/unsecured/defaultSecurity";
        this.assertStatus(path, 403, 401);
    }

    @Test
    public void shouldDenyUnannotatedOnParentClass() {
        String path = "/unsecured/defaultSecurityParent";
        this.assertStatus(path, 403, 401);
    }

    @Test
    public void shouldAllowAnnotatedParentEndpoint() {
        String path = "/unsecured/parent-annotated";
        this.assertStatus(path, 200, 401);
    }

    @Test
    public void shouldAllowAnnotatedEndpointOnInterface() {
        String path = "/unsecured/interface-annotated";
        this.assertStatus(path, 200, 401);
    }

    @Test
    public void shouldDenyUnannotatedOverriddenOnInterfaceImplementor() {
        String path = "/unsecured/interface-overridden-declared-on-implementor";
        this.assertStatus(path, 403, 401);
    }

    @Test
    public void shouldAllowAnnotatedOverriddenEndpointDeclaredOnInterface() {
        String path = "/unsecured/interface-overridden-declared-on-interface";
        this.assertStatus(path, 200, 401);
        ((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic("admin", "admin").get(path, new Object[0])).then()).body(Matchers.is((Object)"implementor-response"), new Matcher[0]);
    }

    @Test
    public void shouldDenyUnannotatedOnInterface() {
        String path = "/unsecured/defaultSecurityInterface";
        this.assertStatus(path, 403, 401);
    }

    @Test
    public void shouldDenyUnannotatedNonBlocking() {
        String path = "/unsecured/defaultSecurityNonBlocking";
        this.assertStatus(path, 403, 401);
    }

    @Test
    public void shouldPermitPermitAllMethodNonBlocking() {
        String path = "/permitAll/defaultSecurityNonBlocking";
        this.assertStatus(path, 200, 200);
    }

    @Test
    public void shouldDenyDenyAllMethod() {
        String path = "/unsecured/denyAll";
        this.assertStatus(path, 403, 401);
    }

    @Test
    public void shouldPermitPermitAllMethod() {
        this.assertStatus("/unsecured/permitAll", 200, 200);
    }

    @Test
    public void shouldDenySubResource() {
        String path = "/unsecured/sub/subMethod";
        this.assertStatus(path, 403, 401);
    }

    @Test
    public void shouldAllowPermitAllSubResource() {
        String path = "/unsecured/permitAllSub/subMethod";
        this.assertStatus(path, 200, 200);
    }

    @Test
    public void shouldAllowPermitAllClass() {
        String path = "/permitAll/sub/subMethod";
        this.assertStatus(path, 200, 200);
    }

    @Test
    public void testServerExceptionMapper() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/hello", new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)"unauthorizedExceptionMapper"), new Matcher[0]);
    }

    @Test
    public void shouldDenyUnannotatedWithAnnotationTransformer() {
        String path = "/special/explicit";
        this.assertStatus(path, 403, 401);
        path = "/special/implicit";
        this.assertStatus(path, 403, 401);
    }

    private void assertStatus(String path, int status, int anonStatus) {
        ((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic("admin", "admin").get(path, new Object[0])).then()).statusCode(status);
        ((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic("user", "user").get(path, new Object[0])).then()).statusCode(status);
        ((ValidatableResponse)((Response)RestAssured.when().get(path, new Object[0])).then()).statusCode(anonStatus);
    }

    @Path(value="/special")
    public static class SpecialResource {
        @GET
        public String explicit() {
            return "explicit";
        }

        public String implicit() {
            return "implicit";
        }
    }
}

