/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.security;

import io.quarkus.security.test.utils.TestIdentityController;
import io.quarkus.security.test.utils.TestIdentityProvider;
import io.quarkus.test.QuarkusUnitTest;
import io.quarkus.test.common.http.TestHTTPResource;
import io.quarkus.vertx.http.runtime.QuarkusHttpHeaders;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpVersion;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class Http2FormAuthRedirectTestCase {
    @TestHTTPResource(value="/j_security_check", ssl=true)
    URL sslUrl;
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{TestIdentityProvider.class, TestIdentityController.class})).addAsResource((Asset)new StringAsset("quarkus.http.auth.form.enabled=true\nquarkus.http.insecure-requests=disabled\nquarkus.http.ssl.certificate.key-store-file=server-keystore.jks\nquarkus.http.ssl.certificate.key-store-password=secret"), "application.properties")).addAsResource("server-keystore.jks");
        }
    });

    @BeforeAll
    public static void setup() {
        TestIdentityController.resetRoles().add("a d m i n", "a d m i n", new String[]{"a d m i n"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFormAuthFailure() {
        try (Vertx vertx = Vertx.vertx();){
            WebClientOptions options = new WebClientOptions().setSsl(true).setVerifyHost(false).setTrustAll(true).setProtocolVersion(HttpVersion.HTTP_2).setFollowRedirects(false).setUseAlpn(true);
            CompletableFuture result = new CompletableFuture();
            QuarkusHttpHeaders formParams = new QuarkusHttpHeaders().add("j_username", "a d m i n").add("j_password", "wrongpassword");
            WebClient.create((Vertx)vertx, (WebClientOptions)options).post(this.sslUrl.getPort(), this.sslUrl.getHost(), this.sslUrl.getPath()).sendForm((MultiMap)formParams, ar -> {
                if (ar.succeeded()) {
                    HttpResponse response = (HttpResponse)ar.result();
                    result.complete(response.statusCode());
                } else {
                    result.completeExceptionally(ar.cause());
                }
            });
            Assertions.assertEquals((int)302, (Integer)((Integer)result.get()));
        }
    }
}

