/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.security;

import io.quarkus.resteasy.reactive.server.test.security.RolesAllowedBlockingResource;
import io.quarkus.resteasy.reactive.server.test.security.RolesAllowedResource;
import io.quarkus.resteasy.reactive.server.test.security.UnsecuredSubResource;
import io.quarkus.resteasy.reactive.server.test.security.UserResource;
import io.quarkus.security.test.utils.TestIdentityController;
import io.quarkus.security.test.utils.TestIdentityProvider;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class LazyAuthRolesAllowedJaxRsTestCase {
    @RegisterExtension
    static QuarkusUnitTest runner = new QuarkusUnitTest().withApplicationRoot(jar -> ((JavaArchive)jar.addClasses(new Class[]{RolesAllowedResource.class, RolesAllowedBlockingResource.class, UserResource.class, TestIdentityProvider.class, TestIdentityController.class, UnsecuredSubResource.class})).addAsResource((Asset)new StringAsset("quarkus.http.auth.proactive=false\n"), "application.properties"));

    @BeforeAll
    public static void setupUsers() {
        TestIdentityController.resetRoles().add("admin", "admin", new String[]{"admin"}).add("user", "user", new String[]{"user"});
    }

    @Test
    public void testRolesAllowed() {
        Arrays.asList("/roles", "/roles-blocking").forEach(path -> {
            ((ValidatableResponse)RestAssured.get((String)path, (Object[])new Object[0]).then()).statusCode(401);
            ((ValidatableResponse)((Response)RestAssured.given().auth().basic("admin", "admin").get(path, new Object[0])).then()).statusCode(200);
            ((ValidatableResponse)((Response)RestAssured.given().auth().basic("admin", "wrong").get(path, new Object[0])).then()).statusCode(401);
            ((ValidatableResponse)((Response)RestAssured.given().auth().basic("user", "user").get(path, new Object[0])).then()).statusCode(200);
            ((ValidatableResponse)((Response)RestAssured.given().auth().basic("admin", "admin").get(path + "/admin", new Object[0])).then()).statusCode(200);
            ((ValidatableResponse)((Response)RestAssured.given().auth().basic("user", "user").get(path + "/admin", new Object[0])).then()).statusCode(403);
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().basic("admin", "admin").get(path + "/admin/security-identity", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"admin"), new Matcher[0]);
        });
    }

    @Test
    public void testUser() {
        ((ValidatableResponse)RestAssured.get((String)"/user", (Object[])new Object[0]).then()).body(Matchers.is((Object)""), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().auth().basic("admin", "admin").get("/user", new Object[0])).then()).body(Matchers.is((Object)""), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic("admin", "admin").get("/user", new Object[0])).then()).body(Matchers.is((Object)""), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().auth().basic("user", "user").get("/user", new Object[0])).then()).body(Matchers.is((Object)""), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic("user", "user").get("/user", new Object[0])).then()).body(Matchers.is((Object)""), new Matcher[0]);
    }
}

