/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.security;

import io.quarkus.resteasy.reactive.server.test.security.TestTrustedIdentityProvider;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.test.utils.TestIdentityController;
import io.quarkus.security.test.utils.TestIdentityProvider;
import io.quarkus.test.QuarkusUnitTest;
import io.quarkus.test.common.http.TestHTTPResource;
import io.quarkus.vertx.http.runtime.security.annotation.BasicAuthentication;
import io.quarkus.vertx.http.runtime.security.annotation.MTLSAuthentication;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.io.File;
import java.net.URL;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class MtlsBasicAnnotationBasedAuthMechSelectionTest {
    @TestHTTPResource(value="/mtls", ssl=true)
    URL mtlsUrl;
    @TestHTTPResource(value="/basic", ssl=true)
    URL basicUrl;
    @RegisterExtension
    static final QuarkusUnitTest config = new QuarkusUnitTest().withApplicationRoot(jar -> ((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)jar.addClasses(new Class[]{MtlsResource.class})).addClasses(new Class[]{TestIdentityProvider.class, TestTrustedIdentityProvider.class, TestIdentityController.class})).addAsResource("mtls/mtls-basic-jks.conf", "application.properties")).addAsResource("mtls/server-keystore.jks", "server-keystore.jks")).addAsResource("mtls/server-truststore.jks", "server-truststore.jks"));

    @BeforeAll
    public static void setup() {
        TestIdentityController.resetRoles().add("admin", "admin", new String[]{"admin"});
    }

    @Test
    public void testMutualTLSAuthenticationEnforced() {
        ((ValidatableResponse)((Response)RestAssured.given().trustStore(new File("src/test/resources/mtls/client-truststore.jks"), "password").get(this.mtlsUrl)).then()).statusCode(401);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().keyStore(new File("src/test/resources/mtls/client-keystore.jks"), "password").trustStore(new File("src/test/resources/mtls/client-truststore.jks"), "password").get(this.mtlsUrl)).then()).statusCode(200)).body(Matchers.is((Object)"CN=client,OU=cert,O=quarkus,L=city,ST=state,C=AU"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic("admin", "admin").trustStore(new File("src/test/resources/mtls/client-truststore.jks"), "password").get(this.mtlsUrl)).then()).statusCode(401);
    }

    @Test
    public void testBasicAuthenticationEnforced() {
        ((ValidatableResponse)((Response)RestAssured.given().trustStore(new File("src/test/resources/mtls/client-truststore.jks"), "password").get(this.basicUrl)).then()).statusCode(401);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic("admin", "admin").trustStore(new File("src/test/resources/mtls/client-truststore.jks"), "password").get(this.basicUrl)).then()).statusCode(200)).body(Matchers.is((Object)"admin"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().keyStore(new File("src/test/resources/mtls/client-keystore.jks"), "password").trustStore(new File("src/test/resources/mtls/client-truststore.jks"), "password").get(this.basicUrl)).then()).statusCode(401);
    }

    @Path(value="/")
    public static class MtlsResource {
        @Inject
        SecurityIdentity identity;

        @MTLSAuthentication
        @Path(value="mtls")
        @GET
        public String mtls() {
            return this.identity.getPrincipal().getName();
        }

        @BasicAuthentication
        @Path(value="basic")
        @GET
        public String basic() {
            return this.identity.getPrincipal().getName();
        }
    }
}

