/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.security;

import io.quarkus.resteasy.reactive.server.test.security.CustomPermission;
import io.quarkus.resteasy.reactive.server.test.security.CustomPermissionWithExtraArgs;
import io.quarkus.security.StringPermission;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.SecurityIdentityAugmentor;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.smallrye.mutiny.Uni;
import jakarta.enterprise.context.ApplicationScoped;
import java.security.Permission;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;

@ApplicationScoped
public class PermissionsIdentityAugmentor
implements SecurityIdentityAugmentor {
    public Uni<SecurityIdentity> augment(SecurityIdentity identity, AuthenticationRequestContext context) {
        if (identity.isAnonymous()) {
            return Uni.createFrom().item((Object)identity);
        }
        return Uni.createFrom().item((Object)this.build(identity));
    }

    SecurityIdentity build(SecurityIdentity identity) {
        QuarkusSecurityIdentity.Builder builder = QuarkusSecurityIdentity.builder((SecurityIdentity)identity);
        switch (identity.getPrincipal().getName()) {
            case "admin": {
                builder.addPermissionChecker(new PermissionCheckBuilder().addPermission("update").addPermission("create").addPermission("read", "resource-admin").addCustomPermission().addCustomPermission("farewell", "so long", "Nelson", 3, "Ostrava").build());
                break;
            }
            case "user": {
                builder.addPermissionChecker(new PermissionCheckBuilder().addPermission("update").addPermission("get-identity").addCustomPermission("farewell", "so long", "Nelson", 3, "Prague").addPermission("read", "resource-admin").build());
                break;
            }
            case "viewer": {
                builder.addPermissionChecker(new PermissionCheckBuilder().addPermission("read", "resource-viewer").build());
            }
        }
        return builder.build();
    }

    private static final class PermissionCheckBuilder {
        private final Set<Permission> permissionSet = new HashSet<Permission>();

        private PermissionCheckBuilder() {
        }

        PermissionCheckBuilder addPermission(String name, String action) {
            this.permissionSet.add((Permission)new StringPermission(name, new String[]{action}));
            return this;
        }

        PermissionCheckBuilder addPermission(String name) {
            this.permissionSet.add((Permission)new StringPermission(name, new String[0]));
            return this;
        }

        PermissionCheckBuilder addCustomPermission() {
            this.permissionSet.add(new CustomPermission("ignored"));
            return this;
        }

        PermissionCheckBuilder addCustomPermission(String permName, String goodbye, String toWhom, int day, String place) {
            this.permissionSet.add(new CustomPermissionWithExtraArgs(permName, goodbye, toWhom, day, place));
            return this;
        }

        Function<Permission, Uni<Boolean>> build() {
            final Set<Permission> immutablePermissions = Set.copyOf(this.permissionSet);
            return new Function<Permission, Uni<Boolean>>(){

                @Override
                public Uni<Boolean> apply(Permission requiredPermission) {
                    return Uni.createFrom().item((Object)immutablePermissions.stream().anyMatch(possessedPermission -> possessedPermission.implies(requiredPermission)));
                }
            };
        }
    }
}

