/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.security;

import io.quarkus.security.ForbiddenException;
import io.quarkus.security.test.utils.TestIdentityController;
import io.quarkus.security.test.utils.TestIdentityProvider;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.resteasy.reactive.server.ServerExceptionMapper;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class ProactiveAuthHttpPolicyForbiddenExMapperTest {
    private static final String PROPERTIES = "quarkus.http.auth.basic=true\nquarkus.http.auth.policy.user-policy.roles-allowed=user\nquarkus.http.auth.permission.roles.paths=/secured\nquarkus.http.auth.permission.roles.policy=user-policy";
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{TestIdentityProvider.class, TestIdentityController.class, CustomForbiddenExceptionMapper.class})).addAsResource((Asset)new StringAsset(ProactiveAuthHttpPolicyForbiddenExMapperTest.PROPERTIES), "application.properties");
        }
    });

    @BeforeAll
    public static void setup() {
        TestIdentityController.resetRoles().add("a d m i n", "a d m i n", new String[]{"a d m i n"});
    }

    @Test
    public void testDeniedAccessAdminResource() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().basic("a d m i n", "a d m i n").when().get("/secured", new Object[0])).then()).statusCode(403)).body(Matchers.equalTo((Object)CustomForbiddenExceptionMapper.CUSTOM_FORBIDDEN_EXCEPTION_MAPPER), new Matcher[0]);
    }

    public static final class CustomForbiddenExceptionMapper {
        public static final String CUSTOM_FORBIDDEN_EXCEPTION_MAPPER = CustomForbiddenExceptionMapper.class.getName();

        @ServerExceptionMapper(value={ForbiddenException.class})
        public jakarta.ws.rs.core.Response forbidden() {
            return jakarta.ws.rs.core.Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)CUSTOM_FORBIDDEN_EXCEPTION_MAPPER).build();
        }
    }

    @Path(value="/secured")
    public static class SecuredResource {
        @GET
        public String get() {
            throw new IllegalStateException();
        }
    }
}

