/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.security;

import io.quarkus.security.ForbiddenException;
import io.quarkus.security.test.utils.TestIdentityController;
import io.quarkus.security.test.utils.TestIdentityProvider;
import io.quarkus.test.QuarkusUnitTest;
import io.quarkus.vertx.web.Route;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.vertx.core.http.HttpServerResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class ProactiveAuthHttpPolicyForbiddenHandlerTest {
    private static final String PROPERTIES = "quarkus.http.auth.basic=true\nquarkus.http.auth.policy.user-policy.roles-allowed=user\nquarkus.http.auth.permission.roles.paths=/secured\nquarkus.http.auth.permission.roles.policy=user-policy";
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{TestIdentityProvider.class, TestIdentityController.class, CustomForbiddenFailureHandler.class})).addAsResource((Asset)new StringAsset(ProactiveAuthHttpPolicyForbiddenHandlerTest.PROPERTIES), "application.properties");
        }
    });

    @BeforeAll
    public static void setup() {
        TestIdentityController.resetRoles().add("a d m i n", "a d m i n", new String[]{"a d m i n"});
    }

    @Test
    public void testDeniedAccessAdminResource() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().basic("a d m i n", "a d m i n").when().get("/secured", new Object[0])).then()).statusCode(403)).body(Matchers.equalTo((Object)CustomForbiddenFailureHandler.CUSTOM_FORBIDDEN_EXCEPTION_MAPPER), new Matcher[0]);
    }

    public static final class CustomForbiddenFailureHandler {
        public static final String CUSTOM_FORBIDDEN_EXCEPTION_MAPPER = CustomForbiddenFailureHandler.class.getName();

        @Route(type=Route.HandlerType.FAILURE)
        void handle(ForbiddenException e, HttpServerResponse response) {
            response.setStatusCode(Response.Status.FORBIDDEN.getStatusCode()).end(CUSTOM_FORBIDDEN_EXCEPTION_MAPPER);
        }
    }

    @Path(value="/secured")
    public static class SecuredResource {
        @GET
        public String get() {
            throw new IllegalStateException();
        }
    }
}

