/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.security;

import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.smallrye.common.annotation.Blocking;
import io.smallrye.common.annotation.NonBlocking;
import jakarta.annotation.security.PermitAll;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;

@Path(value="/roles-blocking")
@PermitAll
@Blocking
public class RolesAllowedBlockingResource {
    @Inject
    CurrentIdentityAssociation currentIdentityAssociation;

    @GET
    @RolesAllowed(value={"user", "admin"})
    public String defaultSecurity() {
        return "default";
    }

    @Path(value="/admin")
    @RolesAllowed(value={"admin"})
    @GET
    public String admin() {
        return "admin";
    }

    @NonBlocking
    @Path(value="/admin/security-identity")
    @RolesAllowed(value={"admin"})
    @GET
    public String getSecurityIdentity() {
        return this.currentIdentityAssociation.getIdentity().getPrincipal().getName();
    }
}

