/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.security;

import jakarta.annotation.security.PermitAll;
import jakarta.annotation.security.RolesAllowed;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.control.ActivateRequestContext;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

@ApplicationScoped
public class RolesAllowedService {
    public static final String SERVICE_HELLO = "Hello from Service!";
    public static final String SERVICE_BYE = "Bye from Service!";
    public static final List<String> EVENT_BUS_MESSAGES = new CopyOnWriteArrayList<String>();

    @RolesAllowed(value={"admin"})
    public String hello() {
        return SERVICE_HELLO;
    }

    @PermitAll
    public String bye() {
        return SERVICE_BYE;
    }

    @PermitAll
    @ActivateRequestContext
    void receivePermitAllMessage(String m) {
        EVENT_BUS_MESSAGES.add("permit all " + m);
    }

    @RolesAllowed(value={"admin"})
    @ActivateRequestContext
    void receiveRolesAllowedMessage(String m) {
        EVENT_BUS_MESSAGES.add("roles allowed " + m);
    }
}

