/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.security;

import io.quarkus.resteasy.reactive.server.test.security.RolesAllowedService;
import io.quarkus.runtime.ShutdownEvent;
import io.quarkus.runtime.StartupEvent;
import io.vertx.core.Vertx;
import io.vertx.mutiny.core.eventbus.EventBus;
import io.vertx.mutiny.core.eventbus.MessageConsumer;
import jakarta.annotation.security.RolesAllowed;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;

@Path(value="/roles-service")
public class RolesAllowedServiceResource {
    private MessageConsumer<String> permitAllConsumer;
    private MessageConsumer<String> rolesAllowedConsumer;
    @Inject
    RolesAllowedService rolesAllowedService;
    @Inject
    EventBus bus;

    @Path(value="/hello")
    @RolesAllowed(value={"user", "admin"})
    @GET
    public String getServiceHello() {
        return this.rolesAllowedService.hello();
    }

    @Path(value="/bye")
    @GET
    public String getServiceBye() {
        return this.rolesAllowedService.bye();
    }

    @Path(value="/secured-event-bus")
    @POST
    public void sendMessage(String message) {
        this.bus.send("roles-allowed-message", (Object)message);
        this.bus.send("permit-all-message", (Object)message);
    }

    void observeStartup(@Observes StartupEvent startupEvent, EventBus eventBus, Vertx vertx) {
        this.permitAllConsumer = eventBus.consumer("permit-all-message").handler(msg -> this.rolesAllowedService.receivePermitAllMessage((String)msg.body()));
        this.rolesAllowedConsumer = eventBus.consumer("roles-allowed-message").handler(msg -> vertx.executeBlocking(() -> {
            this.rolesAllowedService.receiveRolesAllowedMessage((String)msg.body());
            return null;
        }));
    }

    void observerShutdown(@Observes ShutdownEvent shutdownEvent) {
        if (this.permitAllConsumer != null) {
            this.permitAllConsumer.unregister().await().indefinitely();
        }
        if (this.rolesAllowedConsumer != null) {
            this.rolesAllowedConsumer.unregister().await().indefinitely();
        }
    }
}

