/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.security;

import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.security.Principal;

@Provider
@PreMatching
public class SecurityOverrideFilter
implements ContainerRequestFilter {
    public void filter(ContainerRequestContext requestContext) throws IOException {
        final String user = (String)requestContext.getHeaders().getFirst((Object)"User");
        final String role = (String)requestContext.getHeaders().getFirst((Object)"Role");
        if (user != null && role != null) {
            requestContext.setSecurityContext(new SecurityContext(){

                public Principal getUserPrincipal() {
                    return new Principal(){

                        @Override
                        public String getName() {
                            return user;
                        }
                    };
                }

                public boolean isUserInRole(String r) {
                    return role.equals(r);
                }

                public boolean isSecure() {
                    return false;
                }

                public String getAuthenticationScheme() {
                    return "basic";
                }
            });
        }
    }
}

