/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.security;

import io.quarkus.security.Authenticated;
import io.quarkus.security.test.utils.TestIdentityController;
import io.quarkus.security.test.utils.TestIdentityProvider;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.resteasy.reactive.server.providers.serialisers.ServerDefaultTextPlainBodyHandler;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class SecurityWithMethodGenericsTest {
    @RegisterExtension
    static QuarkusUnitTest runner = new QuarkusUnitTest().withApplicationRoot(jar -> jar.addClasses(new Class[]{TestIdentityProvider.class, TestIdentityController.class, BaseResource.class, AuthenticatedResource.class, CustomServerDefaultTextPlainBodyHandler.class}));

    @BeforeAll
    public static void setupUsers() {
        TestIdentityController.resetRoles().add("admin", "admin", new String[]{"admin"}).add("user", "user", new String[]{"user"});
    }

    @Test
    public void test() {
        ((ValidatableResponse)((ValidatableResponse)((Response)this.requestWithBasicAuth().get("/auth/allow", new Object[0])).then()).statusCode(200)).body(CoreMatchers.is((Object)"allow"), new Matcher[0]);
        ((ValidatableResponse)((Response)this.requestWithBasicAuth().contentType("text/plain").body("12345").post("/auth/generic", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((Response)this.requestWithBasicAuth().contentType("text/plain").body("54321").post("/auth/specific", new Object[0])).then()).statusCode(200);
    }

    private RequestSpecification requestWithBasicAuth() {
        return RestAssured.given().auth().preemptive().basic("admin", "admin");
    }

    public static abstract class BaseResource<T> {
        @Path(value="generic")
        @POST
        @Produces(value={"text/plain"})
        @Consumes(value={"text/plain"})
        public String generic(T body) {
            return "generic";
        }

        @Path(value="specific")
        @POST
        @Produces(value={"text/plain"})
        @Consumes(value={"text/plain"})
        public String specific(String body) {
            return "specific";
        }
    }

    @Path(value="auth")
    @Authenticated
    public static class AuthenticatedResource
    extends BaseResource<String> {
        @Path(value="allow")
        @GET
        public String allow() {
            return "allow";
        }
    }

    @Provider
    @Consumes(value={"text/plain"})
    public static class CustomServerDefaultTextPlainBodyHandler
    extends ServerDefaultTextPlainBodyHandler {
        public boolean isReadable(Class type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return true;
        }

        public Object readFrom(Class type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
            return "dummy";
        }
    }
}

