/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.security.inheritance;

import io.quarkus.resteasy.reactive.server.test.security.inheritance.JsonObjectReader;
import io.quarkus.resteasy.reactive.server.test.security.inheritance.SecurityAnnotation;
import io.quarkus.resteasy.reactive.server.test.security.inheritance.SubPaths;
import io.quarkus.security.test.utils.TestIdentityController;
import io.quarkus.security.test.utils.TestIdentityProvider;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public abstract class AbstractImplMethodSecuredTest {
    protected static QuarkusUnitTest getRunner() {
        return AbstractImplMethodSecuredTest.getRunner("");
    }

    protected static QuarkusUnitTest getRunner(String applicationProperties) {
        return new QuarkusUnitTest().withApplicationRoot(jar -> ((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)jar.addPackage("io.quarkus.resteasy.reactive.server.test.security.inheritance.noclassannotation")).addPackage("io.quarkus.resteasy.reactive.server.test.security.inheritance.classrolesallowed")).addPackage("io.quarkus.resteasy.reactive.server.test.security.inheritance.classdenyall")).addPackage("io.quarkus.resteasy.reactive.server.test.security.inheritance.classpermitall")).addPackage("io.quarkus.resteasy.reactive.server.test.security.inheritance.multiple.pathonbase")).addClasses(new Class[]{TestIdentityProvider.class, TestIdentityController.class, SecurityAnnotation.class, SubPaths.class, JsonObjectReader.class})).addAsResource((Asset)new StringAsset(applicationProperties + System.lineSeparator() + "quarkus.log.category.\"io.quarkus.vertx.http.runtime.QuarkusErrorHandler\".level=OFF" + System.lineSeparator()), "application.properties"));
    }

    @BeforeAll
    public static void setupUsers() {
        TestIdentityController.resetRoles().add("admin", "admin", new String[]{"admin"}).add("user", "user", new String[]{"user"});
    }

    protected boolean denyAllUnannotated() {
        return false;
    }

    protected String roleRequiredForUnannotatedEndpoint() {
        return null;
    }

    private void assertPath(String basePath, Object securityAnnotationObj, String classSecurityOn) {
        this.assertPath(basePath, AbstractImplMethodSecuredTest.toSecurityAnnotation(securityAnnotationObj), classSecurityOn);
    }

    private void assertSecuredSubResourcePath(String basePath) {
        String path = SecurityAnnotation.NONE.assemblePath(basePath) + "/secured";
        String methodSubPath = SecurityAnnotation.NONE.methodSubPath(basePath) + "/secured";
        boolean defJaxRsSecurity = this.denyAllUnannotated() || this.roleRequiredForUnannotatedEndpoint() != null;
        SecurityAnnotation securityAnnotation = defJaxRsSecurity ? SecurityAnnotation.NONE : SecurityAnnotation.METHOD_ROLES_ALLOWED;
        this.assertPath(path, methodSubPath, securityAnnotation);
    }

    private void assertPath(String basePath, SecurityAnnotation securityAnnotation, String classSecurityOn) {
        String path = securityAnnotation.assemblePath(basePath, classSecurityOn);
        String methodSubPath = securityAnnotation.methodSubPath(basePath, classSecurityOn);
        this.assertPath(path, methodSubPath, securityAnnotation);
    }

    private void assertPath(String basePath, SecurityAnnotation securityAnnotation) {
        String path = securityAnnotation.assemblePath(basePath);
        String methodSubPath = securityAnnotation.methodSubPath(basePath);
        this.assertPath(path, methodSubPath, securityAnnotation);
    }

    private void assertPath(String path, String methodSubPath, SecurityAnnotation securityAnnotation) {
        boolean denyAccess;
        boolean endpointSecured;
        String invalidPayload = "}{\"simple\": \"obj\"}";
        String validPayload = "{\"simple\": \"obj\"}";
        boolean defJaxRsSecurity = this.denyAllUnannotated() || this.roleRequiredForUnannotatedEndpoint() != null;
        boolean endpointSecuredWithDefJaxRsSec = defJaxRsSecurity && !securityAnnotation.hasSecurityAnnotation();
        boolean bl = endpointSecured = endpointSecuredWithDefJaxRsSec || securityAnnotation.endpointSecured();
        if (endpointSecured) {
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(invalidPayload).post(path, new Object[0])).then()).statusCode(401);
        } else {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(validPayload).post(path, new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)methodSubPath), new Matcher[0]);
        }
        if (endpointSecured) {
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(invalidPayload).auth().preemptive().basic("user", "user").post(path, new Object[0])).then()).statusCode(403);
        } else {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(validPayload).auth().preemptive().basic("user", "user").post(path, new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)methodSubPath), new Matcher[0]);
        }
        boolean bl2 = denyAccess = securityAnnotation.denyAll() || endpointSecuredWithDefJaxRsSec && this.denyAllUnannotated();
        if (denyAccess) {
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(invalidPayload).auth().preemptive().basic("admin", "admin").post(path, new Object[0])).then()).statusCode(403);
        } else {
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(invalidPayload).auth().preemptive().basic("admin", "admin").post(path, new Object[0])).then()).statusCode(500);
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(validPayload).auth().preemptive().basic("admin", "admin").post(path, new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)methodSubPath), new Matcher[0]);
        }
    }

    private static void assertNotFound(String basePath) {
        String path = SecurityAnnotation.NONE.assembleNotFoundPath(basePath);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{\"simple\": \"obj\"}").post(path, new Object[0])).then()).statusCode(404);
    }

    private static SecurityAnnotation toSecurityAnnotation(Object securityAnnotationObj) {
        return SecurityAnnotation.valueOf(securityAnnotationObj.toString());
    }

    @EnumSource(value=SecurityAnnotation.class)
    @ParameterizedTest
    public void test_ClassPathOnInterface_ImplOnBaseResource_ImplMetWithPath(Object securityAnnotationObj) {
        String resourceSubPath = "class-path-on-interface/class-path-on-interface/impl-on-base-resource/impl-met-with-path";
        this.assertPath(resourceSubPath, securityAnnotationObj, "class-security-on-base-");
    }

    @EnumSource(value=SecurityAnnotation.class)
    @ParameterizedTest
    public void test_ClassPathOnResource_ImplOnBaseResource_ImplMetWithPath(Object securityAnnotationObj) {
        String resourceSubPath = "class-path-on-resource/class-path-on-resource/impl-on-base-resource/impl-met-with-path";
        this.assertPath(resourceSubPath, securityAnnotationObj, "class-security-on-base-");
    }

    @Test
    public void test_ClassPathOnParentResource_ImplOnBaseResource_ImplMetWithPath() {
        String resourceSubPath = "class-path-on-parent-resource/class-path-on-parent-resource/impl-on-base-resource/impl-met-with-path";
        AbstractImplMethodSecuredTest.assertNotFound(resourceSubPath);
    }

    @EnumSource(value=SecurityAnnotation.class)
    @ParameterizedTest
    public void test_ClassPathOnInterface_ImplOnBaseResource_InterfaceMetWithPath(Object securityAnnotationObj) {
        String resourceSubPath = "class-path-on-interface/class-path-on-interface/impl-on-base-resource/interface-met-with-path";
        this.assertPath(resourceSubPath, securityAnnotationObj, "class-security-on-base-");
    }

    @EnumSource(value=SecurityAnnotation.class)
    @ParameterizedTest
    public void test_ClassPathOnResource_ImplOnBaseResource_InterfaceMetWithPath(Object securityAnnotationObj) {
        String resourceSubPath = "class-path-on-resource/class-path-on-resource/impl-on-base-resource/interface-met-with-path";
        this.assertPath(resourceSubPath, securityAnnotationObj, "class-security-on-base-");
    }

    @EnumSource(value=SecurityAnnotation.class)
    @ParameterizedTest
    public void test_ClassPathOnParentResource_ImplOnBaseResource_InterfaceMetWithPath(Object securityAnnotationObj) {
        String resourceSubPath = "class-path-on-parent-resource/class-path-on-parent-resource/impl-on-base-resource/interface-met-with-path";
        this.assertPath(resourceSubPath, securityAnnotationObj, "class-security-on-base-");
    }

    @Test
    public void test_ClassPathOnInterface_ImplOnBaseResource_ParentMetWithPath() {
        String resourceSubPath = "class-path-on-interface/class-path-on-interface/impl-on-base-resource/parent-met-with-path";
        AbstractImplMethodSecuredTest.assertNotFound(resourceSubPath);
    }

    @EnumSource(value=SecurityAnnotation.class)
    @ParameterizedTest
    public void test_ClassPathOnResource_ImplOnBaseResource_ParentMetWithPath(Object securityAnnotationObj) {
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
        String resourceSubPath = "class-path-on-resource/class-path-on-resource/impl-on-base-resource/parent-met-with-path";
        this.assertPath(resourceSubPath, securityAnnotationObj, "class-security-on-base-");
    }

    @EnumSource(value=SecurityAnnotation.class)
    @ParameterizedTest
    public void test_ClassPathOnParentResource_ImplOnBaseResource_ParentMetWithPath(Object securityAnnotationObj) {
        String resourceSubPath = "class-path-on-parent-resource/class-path-on-parent-resource/impl-on-base-resource/parent-met-with-path";
        this.assertPath(resourceSubPath, securityAnnotationObj, "class-security-on-base-");
    }

    @EnumSource(value=SecurityAnnotation.class)
    @ParameterizedTest
    public void test_ClassPathOnInterface_SubDeclaredOnInterface_SubImplOnInterface(Object securityAnnotationObj) {
        String resourceSubPath = "class-path-on-interface/class-path-on-interface/sub-resource-declared-on-interface/sub-impl-on-interface";
        this.assertPath(resourceSubPath, securityAnnotationObj, "class-security-on-interface-");
    }

    @Test
    public void test_ClassPathOnInterface_SubDeclaredOnInterface_SubImplOnBase_SecurityInsideSub() {
        String resourceSubPath = "class-path-on-interface/class-path-on-interface/sub-resource-declared-on-interface/sub-impl-on-base";
        this.assertSecuredSubResourcePath(resourceSubPath);
        this.assertSecuredSubResourcePath(resourceSubPath);
    }

    @EnumSource(value=SecurityAnnotation.class)
    @ParameterizedTest
    public void test_ClassPathOnInterface_SubDeclaredOnInterface_SubImplOnParent(Object securityAnnotationObj) {
        String resourceSubPath = "class-path-on-interface/class-path-on-interface/sub-resource-declared-on-interface/sub-impl-on-parent";
        this.assertPath(resourceSubPath, securityAnnotationObj, "class-security-on-parent-");
    }

    @EnumSource(value=SecurityAnnotation.class)
    @ParameterizedTest
    public void test_ClassPathOnResource_SubDeclaredOnBase_SubImplOnBase(Object securityAnnotationObj) {
        String resourceSubPath = "class-path-on-resource/class-path-on-resource/sub-resource-declared-on-base/sub-impl-on-base";
        this.assertPath(resourceSubPath, securityAnnotationObj, "class-security-on-base-");
    }

    @EnumSource(value=SecurityAnnotation.class)
    @ParameterizedTest
    public void test_ClassPathOnParentResource_SubDeclaredOnParent_SubImplOnParent(Object securityAnnotationObj) {
        String resourceSubPath = "class-path-on-parent-resource/class-path-on-parent-resource/sub-resource-declared-on-parent/sub-impl-on-parent";
        this.assertPath(resourceSubPath, securityAnnotationObj, "class-security-on-parent-");
    }

    @EnumSource(value=SecurityAnnotation.class)
    @ParameterizedTest
    public void test_ClassPathOnParentResource_SubDeclaredOnParent_SubImplOnBase(Object securityAnnotationObj) {
        String resourceSubPath = "class-path-on-parent-resource/class-path-on-parent-resource/sub-resource-declared-on-parent/sub-impl-on-base";
        this.assertPath(resourceSubPath, securityAnnotationObj, "class-security-on-base-");
    }

    @Test
    public void test_ClassPathOnInterface_ImplOnParentResource_ImplMetWithPath() {
        String resourceSubPath = "class-path-on-interface/class-path-on-interface/impl-on-parent-resource/impl-met-with-path";
        AbstractImplMethodSecuredTest.assertNotFound(resourceSubPath);
    }

    @EnumSource(value=SecurityAnnotation.class)
    @ParameterizedTest
    public void test_ClassPathOnResource_ImplOnParentResource_ImplMetWithPath(Object securityAnnotationObj) {
        String resourceSubPath = "class-path-on-resource/class-path-on-resource/impl-on-parent-resource/impl-met-with-path";
        this.assertPath(resourceSubPath, securityAnnotationObj, "class-security-on-parent-");
    }

    @EnumSource(value=SecurityAnnotation.class)
    @ParameterizedTest
    public void test_ClassPathOnParentResource_ImplOnParentResource_ImplMetWithPath(Object securityAnnotationObj) {
        String resourceSubPath = "class-path-on-parent-resource/class-path-on-parent-resource/impl-on-parent-resource/impl-met-with-path";
        this.assertPath(resourceSubPath, securityAnnotationObj, "class-security-on-parent-");
    }

    @EnumSource(value=SecurityAnnotation.class)
    @ParameterizedTest
    public void test_ClassPathOnInterface_ImplOnParentResource_InterfaceMetWithPath(Object securityAnnotationObj) {
        String resourceSubPath = "class-path-on-interface/class-path-on-interface/impl-on-parent-resource/interface-met-with-path";
        this.assertPath(resourceSubPath, securityAnnotationObj, "class-security-on-parent-");
    }

    @EnumSource(value=SecurityAnnotation.class)
    @ParameterizedTest
    public void test_ClassPathOnResource_ImplOnParentResource_InterfaceMetWithPath(Object securityAnnotationObj) {
        String resourceSubPath = "class-path-on-resource/class-path-on-resource/impl-on-parent-resource/interface-met-with-path";
        this.assertPath(resourceSubPath, securityAnnotationObj, "class-security-on-parent-");
    }

    @EnumSource(value=SecurityAnnotation.class)
    @ParameterizedTest
    public void test_ClassPathOnParentResource_ImplOnParentResource_InterfaceMetWithPath(Object securityAnnotationObj) {
        String resourceSubPath = "class-path-on-parent-resource/class-path-on-parent-resource/impl-on-parent-resource/interface-met-with-path";
        this.assertPath(resourceSubPath, securityAnnotationObj, "class-security-on-parent-");
    }

    @EnumSource(value=SecurityAnnotation.class)
    @ParameterizedTest
    public void test_ClassPathOnInterface_ImplOnInterface_ImplMetWithPath(Object securityAnnotationObj) {
        String resourceSubPath = "class-path-on-interface/class-path-on-interface/impl-on-interface/impl-met-with-path";
        this.assertPath(resourceSubPath, securityAnnotationObj, "class-security-on-interface-");
    }

    @EnumSource(value=SecurityAnnotation.class)
    @ParameterizedTest
    public void test_ClassPathOnResource_ImplOnInterface_ImplMetWithPath(Object securityAnnotationObj) {
        String resourceSubPath = "class-path-on-resource/class-path-on-resource/impl-on-interface/impl-met-with-path";
        this.assertPath(resourceSubPath, securityAnnotationObj, "class-security-on-interface-");
    }

    @EnumSource(value=SecurityAnnotation.class)
    @ParameterizedTest
    public void test_ClassPathOnParentResource_ImplOnInterface_ImplMetWithPath(Object securityAnnotationObj) {
        String resourceSubPath = "class-path-on-parent-resource/class-path-on-parent-resource/impl-on-interface/impl-met-with-path";
        this.assertPath(resourceSubPath, securityAnnotationObj, "class-security-on-interface-");
    }

    @Test
    public void test_MultipleInheritance_ClassPathOnBase_ImplOnBase_ImplWithPath() {
        String resourceSubPath = "multiple-inheritance-class-path-on-resource/multiple-inheritance-class-path-on-resource/impl-on-base-resource/impl-met-with-path";
        this.assertPath(resourceSubPath, SecurityAnnotation.METHOD_ROLES_ALLOWED);
        this.assertPath(resourceSubPath, SecurityAnnotation.NONE);
    }

    @Test
    public void test_MultipleInheritance_ClassPathOnBase_ImplOnBase_FirstInterface_InterfaceMethodWithPath() {
        String resourceSubPath = "multiple-inheritance-class-path-on-resource/multiple-inheritance-class-path-on-resource/impl-on-base-resource/second-interface/interface-met-with-path";
        this.assertPath(resourceSubPath, SecurityAnnotation.METHOD_ROLES_ALLOWED);
        this.assertPath(resourceSubPath, SecurityAnnotation.NONE);
    }

    @Test
    public void test_MultipleInheritance_ClassPathOnBase_ImplOnBase_SecondInterface_InterfaceMethodWithPath() {
        String resourceSubPath = "multiple-inheritance-class-path-on-resource/multiple-inheritance-class-path-on-resource/impl-on-base-resource/first-interface/interface-met-with-path";
        this.assertPath(resourceSubPath, SecurityAnnotation.METHOD_ROLES_ALLOWED);
        this.assertPath(resourceSubPath, SecurityAnnotation.NONE);
    }

    @Test
    public void test_MultipleInheritance_ClassPathOnBase_ImplOnBase_ThirdInterface_InterfaceMethodWithPath() {
        String resourceSubPath = "multiple-inheritance-class-path-on-resource/multiple-inheritance-class-path-on-resource/impl-on-base-resource/third-interface/interface-met-with-path";
        this.assertPath(resourceSubPath, SecurityAnnotation.METHOD_ROLES_ALLOWED);
        this.assertPath(resourceSubPath, SecurityAnnotation.NONE);
    }

    @Test
    public void test_MultipleInheritance_ClassPathOnBase_ImplOnInterface_ThirdInterface_InterfaceMethodWithPath() {
        String resourceSubPath = "multiple-inheritance-class-path-on-resource/multiple-inheritance-class-path-on-resource/impl-on-interface/third-interface/interface-met-with-path";
        this.assertPath(resourceSubPath, SecurityAnnotation.METHOD_ROLES_ALLOWED);
        this.assertPath(resourceSubPath, SecurityAnnotation.NONE);
    }
}

